<?php
/**
 * Single Product tabs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/tabs.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.8.0
 */

use RTLPlugins\AstarehCore\Controllers\OptionController;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Filter tabs and allow third parties to add their own.
 *
 * Each tab is an array containing title, callback and priority.
 *
 * @see woocommerce_default_product_tabs()
 */
$product_tabs = apply_filters('woocommerce_product_tabs', []);
try {
    $separator = (is_rtl())
        ? OptionController::getOptionValue('general-options-category-separator-rtl', '،')
        : OptionController::getOptionValue('general-options-category-separator-ltr', ',');
} catch (Throwable $e) {
    $separator = ',';
    error_log($e->getMessage(), E_ERROR);
}
global $product;


$terms = get_the_terms($product->get_id(), 'product_tag');
$product_tags = '';
if ($terms && !is_wp_error($terms)) {
    foreach ($terms as $term) {
        $term_link = get_term_link($term);
        $term_name = $term->name;
        $product_tags .= '<div class="rc-single-product-desc-feature-tags-item px-3 py-2 rounded-3 me-3 mb-3 mb-md-0"><a href="' . esc_url($term_link) . '">' . esc_html($term_name) . '</a></div>';
    }
}

?>

<div class="rc-single-product-desc-feature d-flex flex-column mt-5 p-5 rounded-4 container-fluid container-md">
    <!--TABS-->
    <?php if (!empty($product_tabs)) : ?>
        <div class="rc-single-product-desc-feature-top d-flex">
            <ul class="d-flex tabs wc-tabs" role="tablist">
                <?php
                $iteration = 1;
                foreach ($product_tabs as $key => $product_tab) :
                    ?>
                    <li class=" <?php echo $iteration > 1 ? ' ms-1 ms-md-3 ' : '' ?> <?php echo esc_attr($key); ?>_tab rc-single-product-tab-btn d-flex flex-column justify-content-center align-items-center bg-secondary-500 px-4 rounded-3"
                        data-tab="tab-<?php echo esc_attr($key); ?>"
                    >
                        <p class="text-white text-semibold">
                            <?php echo wp_kses_post(apply_filters('woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key)); ?>
                        </p>
                    </li>
                    <?php
                    $iteration++;
                endforeach;
                ?>
            </ul>
        </div>


        <div class="rc-single-product-desc-feature-dw row mt-4">

            <?php foreach ($product_tabs as $key => $product_tab) : ?>
                <div class="rc-single-product-tab-content d-flex flex-column col-12"
                     data-tab="tab-<?php echo esc_attr($key); ?>"
                >
                    <p class="text-justify line-h-normal">
                        <?php
                        if (isset($product_tab['callback'])) {
                            call_user_func($product_tab['callback'], $key, $product_tab);
                        }
                        ?>
                    </p>
                </div>
            <?php endforeach; ?>


        </div>
    <?php endif; ?>


    <!--PRODUCT CATEGORIES AND TAGS-->
    <div class="product_meta">

        <?php do_action('woocommerce_product_meta_start'); ?>

        <!--SKU-->
        <?php if (wc_product_sku_enabled() && ($product->get_sku() || $product->is_type('variable'))) : ?>

            <div class="sku_wrapper my-1"><?php esc_html_e('SKU:', 'woocommerce'); ?>
                <span class="sku">
                    <?php echo ($sku = $product->get_sku()) ? esc_html($sku) : esc_html__('N/A', 'woocommerce'); ?>
                </span>
            </div>

        <?php endif; ?>


        <!--CATEGORIES-->
        <div class="rc-single-product-desc-feature-category d-flex mt-5 position-relative pb-4">
            <?php echo wc_get_product_category_list($product->get_id(), $separator, '<span class="posted_in">' . _n('Category:', 'Categories:', count($product->get_category_ids()), 'woocommerce') . ' ', '</span>'); ?>
        </div>


        <!--TAGS-->
        <div class="rc-single-product-desc-feature-tags d-flex align-items-center mt-3 flex-md-row flex-column">
            <span class="tagged_as me-2 mb-3 mb-md-0 color-primary-200">
                <?php echo _n('Tag:', 'Tags:', count($product->get_tag_ids()), 'woocommerce'); ?>
            </span>

            <div class="tags-item-cnt d-flex flex-wrap">
                <?php echo $product_tags; ?>
            </div>
        </div>

        <?php do_action('woocommerce_product_meta_end'); ?>

    </div>
</div>


<?php do_action('woocommerce_product_after_tabs'); ?>




