<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.6.0
 */

use RTLPlugins\AstarehCore\Controllers\OptionController;

if (!defined('ABSPATH')) {
    exit;
}

if ($related_products) : ?>

    <section class="related products rc-other-posts d-flex flex-column mt-5 p-lg-5 p-1 p-md-3 pb-5 bg-primary-600 rounded-3 m-0">
        <div class="container-fluid container">
            <?php
            $heading = apply_filters('woocommerce_product_related_products_heading', __('Related products', 'woocommerce'));
            $shop_page_url = get_permalink(wc_get_page_id('shop'));


            if ($heading) : ?>
                <div class="rc-title-section d-flex mb-4 bg-primary-500 p-3 rounded-3 align-items-center">
                    <div class="rc-title-section-right">
                        <h2 class="color-secondary-600 text-center"><?php echo esc_html($heading); ?></h2>
                    </div>
                    <div class="rc-title-section-left ms-auto">
                        <div
                            class="rc-title-section-btn-more-posts d-flex flex-column justify-content-center align-items-center bg-secondary-600 rounded-3 py-2 px-3">
                            <a href="<?php echo esc_url($shop_page_url); ?>" class="color-primary-500">
                                <?php echo __("More", _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>


            <div class="rc-product-items-cnt">
                <div class="row gy-4">
                    <?php woocommerce_product_loop_start(); ?>
                    <?php foreach ($related_products as $related_product) :
                        $related_product_image_url = get_the_post_thumbnail_url($related_product->get_id(), 'large');

                        $related_product_regular_price = (float)$related_product->get_regular_price();
                        $related_product_sale_price = (float)$related_product->get_sale_price();


                        $related_product_formatted_regular_price = wc_price($related_product_regular_price);
                        $related_product_formatted_sale_price = wc_price($related_product_sale_price);


                        $categories = get_the_terms($related_product->get_id(), 'product_cat');
                        $parent_categories = [];
                        if ($categories && !is_wp_error($categories)) {
                            $parent_categories = array_filter($categories, function ($item) {
                                return $item->parent === 0;
                            });
                        }

                        $parent_categories_count = count($parent_categories);


                        try {
                            $related_product_discount_percent = astareh_get_product_discount_percent($related_product, false);

                            $separator = OptionController::getOptionValue('general-options-category-separator-ltr');
                            if (is_rtl()) {
                                $separator = OptionController::getOptionValue('general-options-category-separator-rtl');
                            }
                        } catch (Throwable $e) {
                            $separator = ',';
                            $related_product_discount_percent = '';
                            error_log($e->getMessage(), E_ERROR);
                        }

                        ?>

                        <div class="col-lg-4 col-12">
                            <div class="rc-product-item d-flex flex-column p-2 p-md-3 rounded-4">

                                <a class="rc-product-img d-flex rounded-4 overflow-hidden position-relative"
                                   href="<?php echo esc_url(get_permalink($related_product->get_id())); ?>"
                                   target="_blank"
                                >

                                    <!--<div class="rc-product-item-filter position-absolute w-100 h-100 z-1"></div>-->
                                    <img class="w-100"
                                         src="<?php echo esc_html($related_product_image_url) ?>"
                                    >

                                </a><!--.rc-product-img-->


                                <div class="rc-product-title mt-3">
                                    <h3 class="color-secondary-500 related-product-title">
                                        <a class="color-secondary-500"
                                           href="<?php echo esc_url(get_permalink($related_product->get_id())); ?>"
                                        >
                                            <?php echo esc_html($related_product->get_name()); ?>
                                        </a>
                                    </h3>
                                </div>


                                <div class="rc-product-category mt-2 d-flex">
                                    <span>
                                        <?php echo __("Category: ", _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                                    </span>
                                    <?php foreach (array_values($parent_categories) as $iteration => $category): ?>
                                        <a href="<?php echo esc_url(get_term_link($category)) ?>"
                                           class="ms-2 text-white"
                                        >
                                            <?php echo ($iteration < $parent_categories_count - 1 && $parent_categories_count > 1) ? esc_html($category->name) . $separator : esc_html($category->name); ?>
                                        </a>

                                    <?php endforeach; ?>
                                </div>


                                <div class="rc-product-item-spacer my-3"></div>


                                <div class="post-date-read-more d-flex px-2 px-md-1 px-lg-2 overflow-hidden">

                                    <?php if (!empty($related_product_sale_price)): ?>
                                        <div class="product-off-link-more-cnt me-auto position-relative w-fit">
                                            <div
                                                class="rc-product-off-link-more rc-product-off-has-offer position-absolute d-flex flex-column w-fit">
                                                <div
                                                    class="rc-product-off d-flex me-auto flex-column justify-content-center align-items-center mb-auto">
                                                    <a>
                                                        <?php echo esc_html($related_product_discount_percent) ?>
                                                    </a>
                                                </div>
                                                <div
                                                    class="rc-product-read-more d-flex flex-column justify-content-center align-items-center bg-secondary-600 rounded-3 px-2 py-2 w-fit">
                                                    <a class="color-primary-500"
                                                       href="<?php echo esc_url($related_product->add_to_cart_url()) ?>"
                                                    >
                                                        <?php echo esc_html__('Add to cart', 'woocommerce') ?>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="product-off-link-more-cnt me-auto position-relative w-fit">
                                            <div
                                                class="rc-product-off-link-more position-absolute d-flex flex-column w-fit rc-product-off-has-offer mt-5">

                                                <div
                                                    class="rc-product-read-more d-flex flex-column justify-content-center align-items-center bg-secondary-600 rounded-3 px-2 py-2 w-fit mt-4">
                                                    <a class="color-primary-500"
                                                       href="<?php echo esc_url($related_product->add_to_cart_url()) ?>"
                                                    >
                                                        <?php echo esc_html__('Add to cart', 'woocommerce') ?>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (!empty($related_product_sale_price)) : ?>

                                        <div class="rc-product-price-off-cnt rc-has-product-off d-flex flex-column">
                                            <div class="rc-product-price d-flex flex-column">
                                                <a class="ms-auto color-primary-100">
                                                    <?php echo $related_product_formatted_regular_price ?>
                                                </a>
                                            </div>
                                            <div class="rc-product-price-off">
                                                <p>
                                                    <?php echo $related_product_formatted_sale_price ?>
                                                </p>
                                            </div>
                                        </div>

                                    <?php else : ?>
                                        <div class="rc-product-price-off-cnt d-flex flex-column justify-content-center">

                                            <div class="rc-product-price-off">
                                                <p>
                                                    <?php echo $related_product_formatted_regular_price ?>
                                                </p>
                                            </div>
                                        </div>
                                    <?php endif; ?>


                                </div>
                            </div><!--.rc-product-item-->
                        </div><!--.col-lg-4-->

                    <?php endforeach; ?>
                    <?php woocommerce_product_loop_end(); ?>
                </div>
            </div>


        </div>
    </section>
<?php
endif;

wp_reset_postdata();
