<?php
/**
 * Single Product Rating
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/rating.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

global $product;

if (!wc_review_ratings_enabled()) {
    return;
}
$comments_icon_url = get_template_directory_uri() . '/assets/images/comments-icon.svg';
$range = 5;

$rating_count = $product->get_rating_count();
$review_count = $product->get_review_count();
$average = $product->get_average_rating();

$review_count = $product->get_review_count();
if (function_exists('astareh_get_product_discount_percent')) {
    $discount_percent = astareh_get_product_discount_percent($product, true);
}

?>

<div class="rc-single-product-rate-comment-off-cnt position-relative d-flex py-3">
    <div class="rc-single-product-rate-comment-off-right d-flex flex-column w-100 w-md-50">
        <?php if ($rating_count > 0) : ?>
            <div class="rc-single-product-rating-star d-flex align-items-center">
                <div class="rc-single-product-rating d-flex">
                    <div class="rc-single-product-score d-flex mt-3">
                        <span><?php echo (int)$average ?></span>
                        <span>/</span>
                        <span><?php echo (int)$range ?></span>
                    </div>
                </div>
                <div class="rc-single-product-stars-cnt ms-1">
                    <div class="rc-single-product-rate d-flex flex-row-reverse">
                        <?php for ($i = $range; $i > 0; $i--) : ?>
                            <input type="radio" id="star<?php echo esc_attr($i) ?>"
                                   name="rate"
                                   disabled
                                   value="<?php echo esc_attr($i); ?>"
                                <?php echo ((int)$average == $i) ? 'checked' : ''; ?>
                            />
                            <label for="star<?php echo esc_attr($i) ?>"
                                   title="<?php printf(__('%1s Star', _get_theme_constant('THEME_TEXTDOMAIN')), $i) ?>"
                            ></label>
                        <?php endfor; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>


        <div class="rc-single-product-comments-offer mt-3 position-relative pb-3">
            <div class="rc-single-product-comments d-flex">
                <div class="icon">
                    <img width="17.5px" height="17.5px" src="<?php echo esc_url($comments_icon_url) ?>" alt="">
                </div>
                <a href="#reviews" class="ms-2">
                    <?php printf(__('%1s Reviews', _get_theme_constant('THEME_TEXTDOMAIN')), $review_count) ?>
                </a>
            </div>
        </div>
    </div>


    <div class="rc-single-product-rate-comment-off-left w-100 w-md-50 d-flex align-items-center">
        <!--ِDiscount Percent-->
        <?php if (!empty($discount_percent)): ?>
            <div
                class="rc-single-product-offer d-flex flex-column justify-content-center align-items-center px-4 py-2 rounded-3 ms-auto text-center"
            >
                <p>
                    <?php echo esc_html($discount_percent) ?>
                </p>
            </div>
        <?php endif; ?>
    </div>
</div>

