<?php
/**
 * Single Product Thumbnails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-thumbnails.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.8.0
 */

defined('ABSPATH') || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if (!function_exists('wc_get_gallery_image_html')) {
    return;
}

global $product;

$product_gallery_images = $product->get_gallery_image_ids();
$product_featured_image = get_post_thumbnail_id($product->get_id());
$product_gallery_images = [$product_featured_image] + $product_gallery_images;

?>
<!--Thumbnail template-->
<div class="rc-cm-slider-1-slider-dw position-relative mt-4 overflow-hidden">
    <div class="swiper rcSingleProductDw position-relative">
        <div class="swiper-wrapper d-flex">
            <?php
            if ($product_gallery_images && $product->get_image_id()) {
                foreach ($product_gallery_images as $product_gallery_image_id) {
                    $product_gallery_image_source = wp_get_attachment_image_src($product_gallery_image_id, 'thumbnail');
                    $product_gallery_image_url = esc_url($product_gallery_image_source[0]);
                    ?>

                    <div class="swiper-slide">
                        <img
                            src="<?php echo esc_attr($product_gallery_image_url); ?>"
                        >
                    </div>


                    <?php
                }
            }
            ?>
        </div>

    </div>
</div>
