<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */

defined('ABSPATH') || exit;


// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if (!function_exists('wc_get_gallery_image_html')) {
    return;
}

global $product;

$columns = apply_filters('woocommerce_product_thumbnails_columns', 4);

$post_thumbnail_id = $product->get_image_id();
$wrapper_classes = apply_filters(
    'woocommerce_single_product_image_gallery_classes',
    [
        'woocommerce-product-gallery',
        'woocommerce-product-gallery--' . ($post_thumbnail_id ? 'with-images' : 'without-images'),
        'woocommerce-product-gallery--columns-' . absint($columns),
        'images',
    ]
);

$product_gallery_images = $product->get_gallery_image_ids();
$product_featured_image = get_post_thumbnail_id($product->get_id());
$product_gallery_images = [$product_featured_image] + $product_gallery_images;


?>

<div class="rc-cm-slider-1-slider-top">
    <div class="swiper rcSingleProduct">
        <div class="swiper-wrapper d-flex align-items-center">
            <?php foreach ($product_gallery_images as $image_id):
                $image_source = wp_get_attachment_image_src($image_id, 'full');
                ?>

                <div class="swiper-slide woocommerce-product-gallery__image">
                    <div class="rc-cm-slider-1-slider-top-item-img d-flex">
                        <div class="swiper-zoom-container">
                            <img src="<?php echo esc_url($image_source[0]) ?>" alt="">
                        </div>
                    </div>
                </div>

            <?php endforeach; ?>

        </div>
        <div class="swiper-rtl rc-swiper-portfolio-btn-one position-absolute w-100 h-100 top-0">
            <div class="rc-btn-slider-control-cnt">
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
        </div>
    </div>
</div>

<?php do_action('woocommerce_product_thumbnails'); ?>

