<?php

/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 10.2.0
 */

defined('ABSPATH') || exit;

global $product;

if (!$product->is_purchasable()) {
    return;
}


echo wc_get_stock_html($product); // WPCS: XSS ok.

if ($product->is_in_stock()) : ?>
    <?php
    $product_regular_price = (float)$product->get_regular_price();
    $product_sale_price = (float)$product->get_sale_price();

    $product_price_thousand_separator = get_option('woocommerce_price_thousand_separator', ',');
    $product_price_decimal_separator = get_option('woocommerce_price_decimal_separator', '.');
    $product_price_num_decimals = get_option('woocommerce_price_num_decimals', 0);
    $product_price_format = get_option('woocommerce_price_format');

    $product_formatted_regular_price = number_format($product_regular_price, $product_price_num_decimals, $product_price_decimal_separator, $product_price_thousand_separator);
    $product_formatted_sale_price = number_format($product_sale_price, $product_price_num_decimals, $product_price_decimal_separator, $product_price_thousand_separator);
    $store_current_currency = get_woocommerce_currency_symbol();
    ?>


    <?php do_action('woocommerce_before_add_to_cart_form'); ?>

    <form class="cart rc-single-product-buy-price d-flex flex-column flex-md-row mt-4"
          action="<?php echo esc_url(apply_filters('woocommerce_add_to_cart_form_action', $product->get_permalink())); ?>"
          method="post" enctype='multipart/form-data'
    >
        <?php do_action('woocommerce_before_add_to_cart_button'); ?>

        <?php
        do_action('woocommerce_before_add_to_cart_quantity');

        woocommerce_quantity_input(
            [
                'min_value' => apply_filters('woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product),
                'max_value' => apply_filters('woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product),
                'input_value' => isset($_POST['quantity']) ? wc_stock_amount(wp_unslash($_POST['quantity'])) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
            ]
        );

        do_action('woocommerce_after_add_to_cart_quantity');
        ?>
        <div
            class="rc-single-product-buy-price d-flex flex-column flex-md-row mt-xl-auto mt-4 w-100 justify-content-between">
            <div class="d-flex order-md-1 order-2">
                <button
                    type="submit"
                    name="add-to-cart"
                    value="<?php echo esc_attr($product->get_id()); ?>"
                    class="single_add_to_cart_button <?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>  rc-single-product-buy-btn d-flex flex-column justify-content-center order-2 order-md-1 align-items-center bg-secondary-600 px-5 rounded-3 text-md"
                >
                    <?php echo esc_html($product->single_add_to_cart_text()); ?>
                </button>

            </div>
            <div class="rc-single-product-buy-price order-md-2 order-1 mb-md-0 mb-2">
                <?php
                if (!empty($product_sale_price)) :
                    /*PRODUCT WITH DISCOUNT*/
                    ?>
                    <div class="rc-single-product-price-cnt d-flex flex-column ms-md-auto order-1 order-md-2">
                        <div class="rc-single-product-price-cnt-top ms-md-auto me-auto me-md-none">
                            <span>
                                <?php echo esc_html($product_formatted_regular_price) ?>
                            </span>
                        </div>
                        <div class="rc-single-product-price-cnt-dw d-flex align-items-center">
                            <span class="color-secondary-500">
                                <?php echo esc_html($product_formatted_sale_price) ?>
                            </span>
                            <span class="ms-2">
                                <?php echo esc_html($store_current_currency) ?>
                            </span>
                        </div>
                    </div>
                <?php else : /* WITHOUT DISCOUNT*/ ?>
                    <div class="rc-single-product-price-cnt d-flex flex-column ms-md-auto order-1 order-md-2">
                        <div class="rc-single-product-price-cnt-dw d-flex align-items-center">
                            <span class="color-secondary-500">
                                <?php echo esc_html($product_formatted_regular_price) ?>
                            </span>
                            <span class="ms-2">
                                <?php echo esc_html($store_current_currency) ?>
                            </span>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>

        <?php do_action('woocommerce_after_add_to_cart_button'); ?>
    </form>

    <?php do_action('woocommerce_after_add_to_cart_form'); ?>

<?php endif; ?>
