<?php
/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */

defined('ABSPATH') || exit;

global $product;

if (!comments_open()) {
    return;
}


// Comments render
if (!function_exists('astareh_single_product_comment_list_output')) {
    function astareh_single_product_comment_list_output($comment, $args, $depth)
    {
        // Define the HTML structure for each comment
        $comment_rating = get_comment_meta($comment->comment_ID, 'rating', true);
        $empty_rating = 5 - (int)$comment_rating;


        $date = get_comment_date();
        if (is_rtl() && function_exists('jdate')) {
            $timestamp = strtotime($date);
            $date = jdate($timestamp)->format('Y/m/d');
        }
        ?>

        <div class="rc-cm-comments-comment-item d-flex flex-column position-relative pb-4">
            <div class="rc-cm-comments-comment-specification d-flex align-items-center">

                <div class="rc-cm-comments-comment-user-img rounded-3 overflow-hidden">
                    <?php echo get_avatar($comment, 64, $default_value = '', $alt = '', ['class' => 'w-100 h-100']); ?>
                </div>

                <div class="rc-cm-comments-comment-name-date ms-3">
                    <div class="rc-cm-comments-comment-user-name mb-2 color-secondary-600">
                        <?php echo get_comment_author(); ?>
                    </div>

                    <div class="rc-cm-comments-comment-date">
                        <p class="">
                            <?php echo esc_html($date); ?>
                        </p>
                    </div>
                </div>
                <div class="rc-cm-comments-comment-answer ms-auto d-flex">
                    <?php if (!empty($comment_rating)) : ?>
                        <div class="comment-rating">
                            <?php for ($i = 1; $i <= $comment_rating; $i++) : ?>
                                <span class="fas fa-star color-secondary-500"></span>
                            <?php endfor; ?>
                            <?php for ($i = 1; $i <= $empty_rating; $i++) : ?>
                                <span class="far fa-star color-secondary-500"></span>
                            <?php endfor; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="rc-cm-comments-comment-text mt-3">
                <p class="text-justify line-h-normal">
                    <?php echo get_comment_text(); ?>
                </p>
            </div>
        </div>

        <?php
    }
}

add_filter('wp_list_comments_args', function ($args) {
    $args['callback'] = 'astareh_single_product_comment_list_output';
    return $args;
});


if (!function_exists('astareh_woo_comment_form_fields')) {
    function astareh_woo_comment_form_fields($fields)
    {
        if (function_exists('is_product') && is_product()) {
            $comment_field = $fields['comment'];
            unset($fields['comment']);
            $fields['comment'] = $comment_field;

            if (isset($fields['cookies'])) {
                unset($fields['cookies']);
            }
        }
        return $fields;
    }
}
add_filter('comment_form_fields', 'astareh_woo_comment_form_fields', 9);


?>
<section class="rc-cm-comments-cnt py-5 bg-primary-500">
    <div class="container d-flex flex-column">
        <div id="reviews" class="woocommerce-Reviews">
            <div id="comments">
                <div class="title mb-3 mt-4">
                    <h2 class="woocommerce-Reviews-title color-secondary-600 text-xx1">
                        <?php
                        esc_html_e('Reviews', 'woocommerce');
                        ?>
                    </h2>
                </div>


                <?php if (have_comments()) : ?>
                    <div
                        class="commentlist rc-cm-comments d-flex flex-column rounded-4 overflow-hidden p-lg-5 p-3 mt-4">
                        <?php wp_list_comments(apply_filters('woocommerce_product_review_list_args', ['callback' => 'woocommerce_comments'])); ?>
                    </div>


                    <?php
                    if (get_comment_pages_count() > 1 && get_option('page_comments')) :
                        echo '<nav class="woocommerce-pagination pt-4">';
                        paginate_comments_links(
                            apply_filters(
                                'woocommerce_comment_pagination_args',
                                [
                                    'prev_text' => is_rtl() ? '&rarr;' : '&larr;',
                                    'next_text' => is_rtl() ? '&larr;' : '&rarr;',
                                    'type' => 'list',
                                ]
                            )
                        );
                        echo '</nav>';
                    endif;
                    ?>
                <?php else : ?>
                    <p class="woocommerce-noreviews"><?php esc_html_e('There are no reviews yet.', 'woocommerce'); ?></p>
                <?php endif; ?>
            </div>


            <?php if (get_option('woocommerce_review_rating_verification_required') === 'no' || wc_customer_bought_product('', get_current_user_id(), $product->get_id())) : ?>
                <div id="review_form_wrapper"
                     class="rc-cm-comments-new-comment d-flex flex-column p-lg-5 p-3 mt-4 rounded-4 overflow-hidden"
                >

                    <div id="review_form" class="position-relative">
                        <?php
                        $commenter = wp_get_current_commenter();
                        $comment_form = [
                            /* translators: %s is product title */
                            'title_reply' => have_comments() ? esc_html__('Add a review', 'woocommerce') : sprintf(esc_html__('Be the first to review &ldquo;%s&rdquo;', 'woocommerce'), get_the_title()),
                            /* translators: %s is product title */
                            'title_reply_to' => esc_html__('Leave a Reply to %s', 'woocommerce'),
                            'title_reply_before' => '<div class="rc-cm-comments-new-comment-title mb-4"><p class="color-secondary-600">',
                            'title_reply_after' => '</p></div>',
                            'comment_notes_after' => '',
                            'comment_notes_before' => '',
                            'label_submit' => esc_html__('Submit', 'woocommerce'),
                            'logged_in_as' => '',
                            'comment_field' => '',
                        ];


                        $name_email_required = (bool)get_option('require_name_email', 1);

                        $account_page_url = wc_get_page_permalink('myaccount');
                        if ($account_page_url) {
                            /* translators: %s opening and closing link tags respectively */
                            $comment_form['must_log_in'] = '<p class="must-log-in">' . sprintf(esc_html__('You must be %1$slogged in%2$s to post a review.', 'woocommerce'), '<a href="' . esc_url($account_page_url) . '">', '</a>') . '</p>';
                        }


                        $author_field = sprintf('<div class="rc-cm-comments-new-comment-name-email d-flex flex-column flex-md-row">
                            <div class="rc-cm-comments-new-comment-name rc-cm-comments-new-comment-filed-item w-50 px-3 rounded-3 d-flex">
                                <input type="text" 
                                name="author"
                                placeholder="%1s"
                                value="%2s"
                                class="w-100"
                                %3s
                                >
                                <div class="rc-cm-comments-new-comment-icon-field d-flex align-items-center ms-auto">
                                    <i class="iconsax-outline-user-square text-lg color-secondary-600"></i>
                                </div>
                            </div>',
                            __("Name", 'woocommerce'),
                            $commenter['comment_author'],
                            ($name_email_required) ? " required " : " "
                        );
                        $comment_form['fields']['author'] = $author_field;

                        $email_field = sprintf('<div class="rc-cm-comments-new-comment-email rc-cm-comments-new-comment-filed-item w-50 px-3 rounded-3 ms-md-4 mt-4 mt-md-0 d-flex">
                                <input type="email" 
                                name="email"
                                class="w-100" 
                                placeholder="%1s"
                                value="%2s" 
                                %3s >
                                <div class="rc-cm-comments-new-comment-icon-field d-flex align-items-center ms-auto">
                                    <i class="iconsax-outline-sms text-lg color-secondary-600"></i>
                                </div>
                            </div>
                        </div>',
                            __('Email', 'woocommerce'),
                            $commenter['comment_author'],
                            ($name_email_required) ? ' required ' : ''
                        );

                        $comment_form['fields']['email'] = $email_field;


                        if (wc_review_ratings_enabled()) {
                            $rating_field = '<div class="comment-form-rating d-flex justify-content-end position-absolute">
                                <select name="rating" id="rating" required>
                                    <option value="">' . esc_html__('Rate&hellip;', 'woocommerce') . '</option>
                                    <option value="5">' . esc_html__('Perfect', 'woocommerce') . '</option>
                                    <option value="4">' . esc_html__('Good', 'woocommerce') . '</option>
                                    <option value="3">' . esc_html__('Average', 'woocommerce') . '</option>
                                    <option value="2">' . esc_html__('Not that bad', 'woocommerce') . '</option>
                                    <option value="1">' . esc_html__('Very poor', 'woocommerce') . '</option>
                                </select>
					        </div>';

                            $comment_form['comment_field'] = $rating_field;
                        }


                        $comment_form['comment_field'] .= '<div class="rc-cm-comments-new-comment-text-input d-flex flex-column w-100 mt-4 p-3 rounded-3 overflow-hidden">
                            <div class="rc-cm-comments-new-comment-text w-100">
                                <textarea name="comment" id="comment" class="w-100" rows="5" placeholder="' . __('Review', 'woocommerce') . '"></textarea>
                            </div>';

                        $comment_form['submit_button'] = '  <div class="">
                                <button name="%1$s" type="submit" id="%2$s" class="%3$s rc-cm-comments-new-comment-btn-submit ms-auto mt-3 w-fit py-3 px-5 d-flex flex-column justify-content-center align-items-center bg-secondary-600 rounded-3" value="%4$s">%4$s</button>
                            </div>
                            </div>';

                        comment_form(apply_filters('woocommerce_product_review_comment_form_args', $comment_form));
                        ?>
                    </div>
                </div>
            <?php else : ?>
                <p class="woocommerce-verification-required">
                    <?php esc_html_e('Only logged in customers who have purchased this product may leave a review.', 'woocommerce'); ?>
                </p>
            <?php endif; ?>

            <div class="clear"></div>
        </div>
    </div>


</section>
