<?php
/**
 * Order Downloads.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-downloads.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.3.0
 */

use RTLPlugins\AstarehCore\Controllers\OptionController;

if (!defined('ABSPATH')) {
    exit;
}
?>


<section class="woocommerce-order-downloads">


    <?php if (isset($show_title)) : ?>
        <h2 class="woocommerce-order-downloads__title"><?php esc_html_e('Downloads', 'woocommerce'); ?></h2>
    <?php endif; ?>

    <ul class="w-100 woocommerce-table woocommerce-table--order-downloads shop_table shop_table_responsive order_details">

        <?php

        foreach ($downloads as $download) :
            $product_id = $download['product_id'];
            $product = wc_get_product($product_id);

            $product_image_url = get_the_post_thumbnail_url($product_id, 'thumbnail');
            $product_url = esc_url(get_permalink($product_id));
            $product_title = esc_html(get_the_title($product_id));
            $product_categories = get_the_terms($product_id, 'product_cat');
            if (is_wp_error($product_categories)) {
                $product_categories = [];
            }
            try {
                $separator = OptionController::getOptionValue('general-options-category-separator-ltr');
                if (is_rtl()) {
                    $separator = OptionController::getOptionValue('general-options-category-separator-rtl');
                }
            } catch (Throwable $e) {
                $separator = ',';
                error_log($e->getMessage(), E_ERROR);
            }
            ?>
            <li class="w-100 rc-woo-user-panel-downloads-item bg-primary-500 rounded-4 d-flex align-items-center">
                <div
                    class="rc-woo-user-panel-downloads-item-flex-control d-flex flex-column flex-md-row align-items-center w-100"
                >
                    <div
                        class="rc-woo-user-panel-downloads-item-right d-flex flex-column flex-xl-row align-items-center w-100 w-xl-40 gap-4 pe-md-3 pb-4 pb-md-0 position-relative mt-3 mt-xl-0"
                    >
                        <div
                            class="rc-woo-user-panel-downloads-item-img rc-woo-user-panel-downloads-item-inner position-relative rounded-3 overflow-hidden"
                        >
                            <div class="rc-woo-user-panel-downloads-item-img-filter"></div>

                            <img src="<?php echo esc_attr($product_image_url) ?>"
                                 alt=""
                                 class="w-100"
                            >
                        </div>
                        <div
                            class="rc-woo-user-panel-downloads-item-title rc-woo-user-panel-downloads-item-inner d-flex flex-column position-relative"
                        >
                            <div class="rc-woo-user-panel-downloads-item-title-product">
                                <a class="text-sm text-xl-md"
                                   href="<?php echo esc_url($product_url) ?>"
                                >
                                    <?php echo esc_html($product_title) ?>
                                </a>
                            </div>
                            <div
                                class="rc-woo-user-panel-downloads-item-category rc-woo-user-panel-downloads-item-inner d-flex position-relative pe-md-5 justify-content-center justify-content-md-start align-items-center flex-wrap"
                            >
                                <span class="text-lg-sm text-xs-xs color-primary-200">
                                    <?php echo __("Category:", _get_theme_constant('THEME_TEXTDOMAIN')) ?>
                                </span>

                                <?php if (!empty($product_categories)): ?>
                                    <?php
                                    $count_categories = count($product_categories);

                                    ?>
                                    <?php foreach ($product_categories as $category_index => $category): ?>

                                        <a
                                            href="<?php echo esc_url(get_term_link($category, 'product_cat')) ?>"
                                            class="ms-1 text-lg-sm text-xs-xs  pe-1 color-primary-200"
                                        >
                                            <?php echo esc_html($category->name); ?>
                                            <?php if ($category_index < $count_categories - 1 && $count_categories > 1){
                                                echo esc_html($separator);
                                            } ?>

                                        </a>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div
                        class="rc-woo-user-panel-downloads-item-left d-flex flex-column flex-xl-row align-items-center w-100 w-xl-60 gap-xl-5 ps-md-5 pt-4 pt-md-0">
                        <div
                            class="rc-woo-user-panel-downloads-item-price-cnt rc-woo-user-panel-downloads-item-inner d-flex flex-column justify-content-center position-relative pe-md-5">
                            <span class="text-sm purchase-amount">
                                <?php echo __('Download Count', _get_theme_constant('THEME_TEXTDOMAIN')) ?>
                            </span>
                            <div class="rc-woo-user-panel-downloads-item-purchase-cnt d-flex pb-4 pb-md-0">
                                <span class="text-sm text-lg-md">
                                    <?php echo is_numeric($download['downloads_remaining'])
                                        ? esc_html($download['downloads_remaining'])
                                        : esc_html__('&infin;', 'woocommerce');
                                    ?>
                                </span>
                            </div>
                        </div>
                        <div
                            class="rc-woo-user-panel-downloads-item-date rc-woo-user-panel-downloads-item-inner  d-flex flex-column justify-content-center position-relative pe-md-4 pb-4 pb-md-0">
                            <span class="text-sm download-date">
                                <?php echo __('Expire Date', _get_theme_constant('THEME_TEXTDOMAIN')) ?>
                            </span>
                            <div
                                class="rc-woo-user-panel-downloads-item-date-cnt  d-flex flex-column justify-content-center d-flex">
                                <span class="text-sm text-lg-md">
                                    <?php if (!empty($download['access_expires'])) : ?>
                                        <time
                                            datetime="<?php echo esc_attr(date('Y-m-d', strtotime($download['access_expires']))) ?>"
                                            title="<?php echo esc_attr(strtotime($download['access_expires'])) ?>"
                                        >
                                            <?php
                                            $time_stamp = strtotime($download['access_expires']);
                                            if (is_rtl() && function_exists('jdate')) {
                                                $publish_date = jdate($time_stamp)->format('d F Y');
                                            } else {
                                                $publish_date = date_i18n(get_option('date_format'), $time_stamp);
                                            }
                                            echo esc_html($publish_date);
                                            ?>
                                        </time>
                                    <?php else: ?>
                                        <?php esc_html_e('Never', 'woocommerce'); ?>
                                    <?php endif; ?>
                                </span>
                            </div>
                        </div>
                        <div
                            class="rc-woo-user-panel-downloads-item-links rc-woo-user-panel-downloads-item-inner position-relative ms-lg-auto d-flex flex-column justify-content-center"
                        >
                            <div class="rc-woo-user-panel-downloads-item-links-cnt d-flex">
                                <div class="rc-woo-user-panel-downloads-product-details-btn">
                                    <a href="<?php echo esc_url($product_url); ?>"
                                       class="px-xxl-5 py-xxl-3 px-xl-4 py-xl-3 px-lg-3 py-lg-2 px-2 py-1 bg-primary-500 rounded-3"
                                    >
                                        <?php echo __('Product Details', _get_theme_constant('THEME_TEXTDOMAIN')) ?>
                                    </a>
                                </div>
                                <div class="rc-woo-user-panel-downloads-product-download-btn ms-3">
                                    <a href="<?php echo esc_url($download['download_url']); ?>"
                                       class="px-xxl-5 py-xxl-3 px-xl-4 py-xl-3 px-lg-3 py-lg-2 px-2 py-1 rounded-3 w-100"
                                       title="<?php echo esc_html($download['download_name']); ?>"
                                    >
                                        <?php echo __('Download', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </li>
        <?php endforeach; ?>
    </ul>
</section>
