<?php
/**
 * Order Customer Details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details-customer.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.7.0
 */

defined('ABSPATH') || exit;

$show_shipping = !wc_ship_to_billing_address_only() && $order->needs_shipping_address();

?>
<section class="woocommerce-customer-details">
    <h2 class="woocommerce-column__title"><?php esc_html_e('Billing address', 'woocommerce'); ?></h2>


    <address class="w-100 rc-woo-user-panel-address-item p-4 bg-primary-500 rounded-4 d-flex align-items-center">
        <div
            class="rc-woo-user-panel-address-item-flex-control d-flex flex-column flex-md-row align-items-center w-100">
            <div
                class="rc-woo-user-panel-address-right d-flex flex-column flex-lg-row align-items-center w-100 w-lg-70 gap-4 pe-md-3 pb-4 pb-md-0 position-relative">
                <div
                    class="rc-woo-user-panel-address-item-img rc-woo-user-panel-address-item-inner position-relative rounded-3 d-flex flex-column justify-content-center align-items-center">
                    <i class="iconsax-outline-location text-xx1 color-primary-500"></i>
                </div>
                <div
                    class="rc-woo-user-panel-address-item-title rc-woo-user-panel-address-item-inner d-flex flex-column position-relative">
                    <div class="rc-woo-user-panel-address-item-title-address">
                        <div class="text-sm text-xl-md">
                            <?php echo wp_kses_post(preg_replace("/<br\W*?\/>/", ' - ', $order->get_formatted_billing_address(esc_html__('N/A', 'woocommerce')))); ?>
                            <?php if ($order->get_billing_phone()) : ?>
                                <p class="woocommerce-customer-details--phone"><?php echo esc_html($order->get_billing_phone()); ?></p>
                            <?php endif; ?>
                            <?php if ($order->get_billing_email()) : ?>
                                <p class="woocommerce-customer-details--email"><?php echo esc_html($order->get_billing_email()); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </address>

    <?php if ($show_shipping) : ?>
        <h2 class="woocommerce-column__title mt-5"><?php esc_html_e('Shipping address', 'woocommerce'); ?></h2>
        <address class="w-100 rc-woo-user-panel-address-item p-4 bg-primary-500 rounded-4 d-flex align-items-center">
            <div class="rc-woo-user-panel-address-item-flex-control d-flex flex-column flex-md-row align-items-center w-100">
                <div
                    class="rc-woo-user-panel-address-right d-flex flex-column flex-lg-row align-items-center w-100 w-lg-70 gap-4 pe-md-3 pb-4 pb-md-0 position-relative"
                >
                    <div
                        class="rc-woo-user-panel-address-item-img rc-woo-user-panel-address-item-inner position-relative rounded-3 d-flex flex-column justify-content-center align-items-center"
                    >
                        <i class="iconsax-outline-location text-xx1 color-primary-500"></i>
                    </div>
                    <div class="rc-woo-user-panel-address-item-title rc-woo-user-panel-address-item-inner d-flex flex-column position-relative">
                        <div class="rc-woo-user-panel-address-item-title-address">
                            <div class="text-sm text-xl-md">
                                <?php echo wp_kses_post(preg_replace("/<br\W*?\/>/", ' - ', $order->get_formatted_shipping_address(esc_html__('N/A', 'woocommerce')))); ?>
                                <?php if ($order->get_shipping_phone()) : ?>
                                    <p class="woocommerce-customer-details--phone"><?php echo esc_html($order->get_shipping_phone()); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </address>

    <?php endif; ?>


    <?php do_action('woocommerce_order_details_after_customer_details', $order); ?>



    <a href="<?php echo esc_url(home_url())?>"
       class="rc-btn-back-to-main-page px-5 py-3 bg-secondary-600 rounded-4 color-primary-500 ms-md-auto me-md-0 ms-auto me-auto mt-5">
        <?php echo esc_html__('Main Page', _get_theme_constant('THEME_TEXTDOMAIN'))?>
    </a>

</section>
