<?php
/**
 * Orders
 *
 * Shows orders on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/orders.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.5.0
 */
defined('ABSPATH') || exit;

do_action('woocommerce_before_account_orders', $has_orders); ?>

<?php if ($has_orders) : ?>
<div class="rc-woo-user-panel-user-orders w-100">
    <div class="table-sec-cnt flex w100">
        <div class="rc-woo-user-panel-user-orders-table-cnt flex overflow-hidden overflow-x-auto">
            <div class="cnt w-100">


                <table
                    class="woocommerce-orders-table woocommerce-MyAccount-orders shop_table shop_table_responsive my_account_orders account-orders-table w-100"
                    id="rc-woo-user-panel-user-orders-table"
                >
                    <thead style="vertical-align:bottom">
                    <tr>
                        <?php foreach (wc_get_account_orders_columns() as $column_id => $column_name) : ?>
                            <th class="woocommerce-orders-table__header woocommerce-orders-table__header-<?php echo esc_attr($column_id); ?>">
                                <span class="nobr"><?php echo esc_html($column_name); ?></span></th>
                        <?php endforeach; ?>
                    </tr>
                    </thead>

                    <tbody>
                    <?php
                    foreach ($customer_orders->orders as $customer_order) {
                        $order = wc_get_order($customer_order); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
                        $item_count = $order->get_item_count() - $order->get_item_count_refunded();
                        ?>
                        <tr class="woocommerce-orders-table__row woocommerce-orders-table__row--status-<?php echo esc_attr($order->get_status()); ?> order">
                            <?php foreach (wc_get_account_orders_columns() as $column_id => $column_name) : ?>
                                <td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-<?php echo esc_attr($column_id); ?>"
                                    data-title="<?php echo esc_attr($column_name); ?>">
                                    <?php if (has_action('woocommerce_my_account_my_orders_column_' . $column_id)) : ?>
                                        <?php do_action('woocommerce_my_account_my_orders_column_' . $column_id, $order); ?>

                                    <?php elseif ('order-number' === $column_id) : ?>
                                        <a
                                            class="color-white"
                                            href="<?php echo esc_url($order->get_view_order_url()); ?>"
                                        >
                                            <?php echo esc_html($order->get_order_number()); ?>
                                        </a>

                                    <?php elseif ('order-date' === $column_id) : ?>
                                        <time
                                            datetime="<?php echo esc_attr($order->get_date_created()->date('c')); ?>"
                                        >
                                            <?php
                                            $order_created_date = $order->get_date_created();
                                            if (is_rtl() && function_exists('jdate')) {
                                                // Convert to jalali based on reverse date format of woocommerce
                                                $order_created_date = jdate($order_created_date)->format(wc_date_format());
                                            } else {
                                                $order_created_date = wc_format_datetime($order_created_date);
                                            }
                                            echo esc_html($order_created_date);
                                            ?>
                                        </time>

                                    <?php elseif ('order-status' === $column_id) : ?>
                                        <?php echo esc_html(wc_get_order_status_name($order->get_status())); ?>

                                    <?php elseif ('order-total' === $column_id) : ?>
                                        <?php
                                        /* translators: 1: formatted order total 2: total order items */
										/* translators: 1: formatted order total 2: total order items */
										$formatted_total = $order->get_formatted_order_total();
										$item_count_text = sprintf( _n( 'for %d item', 'for %d items', $item_count, _get_theme_constant( 'THEME_TEXTDOMAIN' ) ), $item_count );
										echo wp_kses_post( sprintf( '%1$s <span class="item-count">%2$s</span>', $formatted_total, $item_count_text ) );
                                        ?>

                                    <?php elseif ('order-actions' === $column_id) : ?>
                                        <?php
                                        $actions = wc_get_account_orders_actions($order);

                                        if (!empty($actions)) {
                                            foreach ($actions as $key => $action) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
                                                echo '<a class="rc-woo-user-panel-user-orders-btn-details px-2 py-3 rounded-3 d-flex mx-auto justify-content-center" href="' . esc_url($action['url']) . '">' . esc_html($action['name']) . '</a>';
                                            }
                                        }
                                        ?>
                                    <?php endif; ?>
                                </td>
                            <?php endforeach; ?>
                        </tr>
                        <?php
                    }
                    ?>
                    </tbody>
                </table>

                <?php do_action('woocommerce_before_account_orders_pagination'); ?>

                <?php if (1 < $customer_orders->max_num_pages) : ?>
                    <div
                        class="woocommerce-pagination woocommerce-pagination--without-numbers woocommerce-Pagination d-flex">
                        <?php if (1 !== $current_page) : ?>
                            <a class="woocommerce-button woocommerce-button--previous woocommerce-Button woocommerce-Button--previous d-flex flex-column bg-secondary-500 rounded-3 align-items-center px-3 py-2 w-fit mx-auto mt-4 color-primary-500 <?php echo esc_attr($wp_button_class); ?>"
                               href="<?php echo esc_url(wc_get_endpoint_url('orders', $current_page - 1)); ?>"><?php esc_html_e('Previous', 'woocommerce'); ?></a>
                        <?php endif; ?>

                        <?php if (intval($customer_orders->max_num_pages) !== $current_page) : ?>
                            <a class="woocommerce-button woocommerce-button--next woocommerce-Button woocommerce-Button--next d-flex flex-column bg-secondary-500 rounded-3 align-items-center px-3 py-2 w-fit mx-auto mt-4 color-primary-500 <?php echo esc_attr($wp_button_class); ?>"
                               href="<?php echo esc_url(wc_get_endpoint_url('orders', $current_page + 1)); ?>"><?php esc_html_e('Next', 'woocommerce'); ?></a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>


            </div>
        </div>
    </div>

    <?php else : ?>

        <?php wc_print_notice(esc_html__('No order has been made yet.', 'woocommerce') . ' <a class="woocommerce-Button button' . esc_attr($wp_button_class) . '" href="' . esc_url(apply_filters('woocommerce_return_to_shop_redirect', wc_get_page_permalink('shop'))) . '">' . esc_html__('Browse products', 'woocommerce') . '</a>', 'notice'); // phpcs:ignore WooCommerce.Commenting.CommentHooks.MissingHookComment ?>

    <?php endif; ?>

    <?php do_action('woocommerce_after_account_orders', $has_orders); ?>
