<?php
/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

if (!defined('ABSPATH')) {
    exit;
}
$dots_image_url = esc_url(get_template_directory_uri() . '/assets/images/dots-one.png');
$user_id = get_current_user_id();
$user = get_user_by('id', $user_id);
$user_name = $user->get('display_name');
$user_avatar_html = get_avatar(
    $user_id,
    'full',
    $default_value = '',
    $alt = '',
    ['class' => 'rounded-circle overflow-hidden']
);

/**
 * Get the menu icon in woocommerce my account dashboard based on endpoint
 * @param string $endpoint
 * @return string
 */
function astareh_get_menu_icon(string $endpoint): string
{
    switch ($endpoint) {
        case 'dashboard':
            return 'iconsax-outline-user-square';
        case 'orders':
            return 'iconsax-outline-square';
        case 'downloads':
            return 'iconsax-outline-document-download';
        case 'edit-address':
            return 'iconsax-outline-location';
        case 'edit-account':
            return 'iconsax-outline-edit';
        case 'customer-logout':
            return 'iconsax-outline-logout';
        default:
            return 'iconsax-outline-candle';
    }
}


?>
<div class="rc-woo-user-panel-menu d-flex flex-md-row flex-column p-4 bg-primary-600 rounded-4">
    <div class="rc-woo-user-profile d-flex align-items-center ms-md-4 position-relative">

        <div class="rc-woo-user-profile-obj-cnt position-absolute">
            <img class="w-100" src="<?php echo esc_url($dots_image_url); ?>" alt="">
        </div>

        <div
            class="rc-woo-user-profile-img-cnt rounded-circle overflow-hidden d-flex flex-column justify-content-center align-items-center">
            <div
                class="rc-user-profile-img rounded-circle overflow-hidden d-flex flex-column justify-content-center align-items-center">
                <?php echo $user_avatar_html; ?>

            </div>
        </div>
        <div class="rc-woo-user-specifications d-flex flex-column ms-4">
            <div class="rc-woo-user-name">
                <a class="color-secondary-600">
                    <?php echo esc_html($user_name); ?>
                </a>
            </div>
            <div class="rc-woo-user-id">
                <span class="color-primary-200">
                    <?php echo __('User Code: ', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                </span>
                <span class="color-primary-200">
                    <?php echo esc_html($user_id); ?>
                </span>
            </div>
        </div>

    </div>

    <?php do_action('woocommerce_before_account_navigation'); ?>

    <nav class="woocommerce-MyAccount-navigation rc-woo-user-panel-nav ms-md-5 mt-4 mt-md-0 overflow-auto">
        <ul class="d-flex pb-4">
            <?php foreach (wc_get_account_menu_items() as $endpoint => $label) : ?>
                <?php
                /*
                 * Process each menu item individually
                 * Check icons and the current link
                */
                $current_url = home_url() . $_SERVER['REQUEST_URI'];
                $endpoint_url = esc_url(wc_get_account_endpoint_url($endpoint));
                $menu_icon_class = astareh_get_menu_icon($endpoint);

                ?>
                <li class="<?php echo wc_get_account_menu_item_classes($endpoint); ?> rc-woo-user-pane-nav-item-cnt position-relative ps-3">
                    <a class="text-white" href="<?php echo esc_url($endpoint_url) ?>">
                        <div
                            class="rc-woo-user-pane-nav-item bg-primary-500 rounded-4 p-3 d-flex flex-column justify-content-center align-items-center"
                        >
                            <div class="rc-woo-panel-item-icon d-flex w-fit">
                                <i class="<?php echo esc_attr($menu_icon_class) ?>  text-xx1 color-primary-200"></i>
                            </div>
                            <div class="rc-woo-panel-item-title mt-3 text-center">
                                <?php echo esc_html__($label, _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                            </div>
                            <?php
                            // Check if similarity of url is above 95 score, then active it!
                            $similarity = 0;
                            similar_text($endpoint_url, $current_url, $similarity);
                            if ($similarity > 95): ?>
                                <div class="rc-woo-panel-item-page-now mt-2">
                                    <i class="iconsax-outline-arrow-down-1"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                    </a>
                </li>
            <?php endforeach; ?>


        </ul>
    </nav>
    <?php do_action('woocommerce_after_account_navigation'); ?>
</div>

