<?php

/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version  9.3.0
 */

defined('ABSPATH') || exit;

$customer_id = get_current_user_id();

if (!wc_ship_to_billing_address_only() && wc_shipping_enabled()) {
    $get_addresses = apply_filters(
        'woocommerce_my_account_get_addresses',
        [
            'billing' => __('Billing address', 'woocommerce'),
            'shipping' => __('Shipping address', 'woocommerce'),
        ],
        $customer_id
    );
} else {
    $get_addresses = apply_filters(
        'woocommerce_my_account_get_addresses',
        [
            'billing' => __('Billing address', 'woocommerce'),
        ],
        $customer_id
    );
}


?>

<p class="mb-4 text-center text-md-2">
    <?php echo apply_filters('woocommerce_my_account_my_address_description', esc_html__('The following addresses will be used on the checkout page by default.', 'woocommerce')); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
</p>

<div class="rc-woo-user-pane-address-list-cnt w-100">
    <ul class="w-100">
        <?php foreach ($get_addresses as $name => $address_title) : ?>
            <?php
            $address = str_replace('<br/>', ' - ', wc_get_account_formatted_address($name));

            ?>
            <h3><?php echo esc_html($address_title); ?></h3>
            <li class="woocommerce-Address w-100 rc-woo-user-panel-address-item p-4 bg-primary-500 rounded-4 d-flex align-items-center">
                <div
                    class="rc-woo-user-panel-address-item-flex-control d-flex flex-column flex-md-row align-items-center w-100">
                    <header
                        class="woocommerce-Address-title title rc-woo-user-panel-address-right rounded-4 p-md-3 pt-md-0 d-flex flex-column flex-lg-row align-items-center w-100 w-md-70 gap-4 pe-md-3 pb-md-0 position-relative">

                        <div
                            class="rc-woo-user-panel-address-item-img rc-woo-user-panel-address-item-inner position-relative rounded-3 d-flex flex-column justify-content-center align-items-center">
                            <i class="iconsax-outline-location text-xx1 color-primary-500"></i>
                        </div>


                        <address>
                            <div
                                class="rc-woo-user-panel-address-item-title rc-woo-user-panel-address-item-inner d-flex flex-column position-relative">
                                <div class="rc-woo-user-panel-address-item-title-address">
                                    <a class="text-sm text-xl-md" href="javascript:void(0)">
                                        <?php
                                        echo $address ? wp_kses_post($address) : esc_html_e('You have not set up this type of address yet.', 'woocommerce');
                                        ?>
                                    </a>
                                </div>
                            </div>
                        </address>



                    </header>
                    <div class="rc-woo-user-panel-address-item-left d-flex flex-column flex-lg-row align-items-center w-100 w-md-30 gap-4 ps-md-5 pt-5 pb-4 pb-md-0 pt-md-0">

                        <div class="rc-woo-user-panel-address-item-btn rc-woo-user-panel-address-item-inner position-relative  d-flex flex-column justify-content-center ms-lg-auto">
                            <div class="rc-woo-user-panel-address-item-btn-cnt d-flex">
                                <div class="">
                                    <a href="<?php echo esc_url(wc_get_endpoint_url('edit-address', $name)); ?>"
                                       class="edit rc-woo-user-panel-address-edit px-xxl-5 py-3 px-4 rounded-3 color-white"
                                    >
                                        <?php echo $address ? esc_html__('Edit', 'woocommerce') : esc_html__('Add', 'woocommerce'); ?>
                                    </a>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </li>

        <?php endforeach; ?>

    </ul>
</div>