<?php
/**
 * My Account page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

use RTLPlugins\AstarehCore\Controllers\MetaboxController;

defined('ABSPATH') || exit;

if (function_exists('astareh_breadcrumb')) {
    astareh_breadcrumb();
}
?>
<!--Custom styling: color,...-->
<?php
if (class_exists('\RTLPlugins\AstarehCore\Controllers\MetaboxController')):
    $page_background_color = MetaboxController::getMetaValue('metaboxes-page-color', true, '', get_the_ID());
    ?>
    <style>
        body {
            background-color: <?php echo esc_html($page_background_color); ?> !important;
        }
    </style>
<?php
endif;
?>

<div class="rc-sec-woo-user-panel">
    <div class="container-fluid container-md p-0">

        <div class="rc-woo-user-title-panel p-3 rounded-3 bg-primary-600 d-flex align-items-center my-5">
            <div class="rc-title-single-portfolio">
                <p class="color-secondary-600 text-xx1">
                    <?php echo __('User Panel', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                </p>
            </div>
        </div>


        <?php
        /**
         * My Account navigation.
         *
         * @since 2.6.0
         */
        do_action('woocommerce_account_navigation');
        ?>

        <div
            class="rc-woo-user-panel-content rounded-4 p-4 p-md-5 mt-5 d-flex flex-column justify-content-center align-content-center">
            <div class="woocommerce-MyAccount-content">
                <?php
                /**
                 * My Account content.
                 *
                 * @since 2.6.0
                 */
                do_action('woocommerce_account_content');
                ?>
            </div><!--.woocommerce-MyAccount-content-->
        </div><!--.rc-woo-user-panel-content-->

    </div>
</div>

