<?php
/**
 * Lost password confirmation text.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/lost-password-confirmation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.9.0
 */

use RTLPlugins\AstarehCore\Admin\OptionLogic;
use RTLPlugins\AstarehCore\Controllers\OptionController;

defined('ABSPATH') || exit;
$dots_image_url = get_template_directory_uri() . '/assets/images/dots-one.png';
$background_image_url = get_template_directory_uri() . '/assets/images/main-background-image.png';
try {
    if(is_rtl()){
        $logo_image_url = OptionLogic::getSafeImageUrl(OptionController::getOptionValue('general-logo-image'));
    } else {
        $logo_image_url = OptionLogic::getSafeImageUrl(OptionController::getOptionValue('general-logo-image-ltr'));
    }
} catch (Throwable $e) {
    $logo_image_url = '';
    error_log($e->getMessage(), E_ERROR);
}


?>
<style>
    #site-header {
        display: none;
    }

    #site-footer {
        display: none;
    }

    .rc-sec-register-sms {
        background-image: url("<?php echo esc_url($background_image_url); ?>");
    }
</style>

<section class="rc-sec-register-sms">
    <div class="container position-relative">
        <div class="rc-cm-register-sms-cnt-one d-flex flex-column justify-content-center align-items-center">
            <div class="rc-cm-register-sms-cnt-two d-flex flex-column">

                <div class="rc-cm-register-sms-form d-flex flex-column bg-primary-register-login rounded-4 p-5">
                    <?php
                    wc_print_notice(esc_html__('Password reset email has been sent.', 'woocommerce'));
                    ?>

                    <?php do_action('woocommerce_before_lost_password_confirmation_message'); ?>

                    <p><?php echo esc_html(apply_filters('woocommerce_lost_password_confirmation_message', esc_html__('A password reset email has been sent to the email address on file for your account, but may take several minutes to show up in your inbox. Please wait at least 10 minutes before attempting another reset.', 'woocommerce'))); ?></p>

                    <?php do_action('woocommerce_after_lost_password_confirmation_message'); ?>
                </div>

                <a href="<?php echo esc_url(home_url()); ?>"
                   class="w-100 text-end pe-5 mt-2 rc-register-sms-return-home-link"
                >
                    <?php echo __('Back to Home', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                </a>
            </div>
        </div>
        <div class="rc-obj-page-login-register-cnt position-absolute w-100 h-100 top-0">
            <div class="rc-obj-page-login-register-one">
                <img class="w-100"
                     src="<?php echo esc_url($dots_image_url); ?>"
                     alt=""
                >
            </div>
            <div class="rc-obj-page-login-register-two">
                <img class="w-100"
                     src="<?php echo esc_url($dots_image_url); ?>"
                     alt=""
                >
            </div>
        </div>
    </div>
</section>