<?php

/**
 * Lost password reset form.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-reset-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version  9.2.0
 */

use RTLPlugins\AstarehCore\Admin\OptionLogic;
use RTLPlugins\AstarehCore\Controllers\OptionController;

defined('ABSPATH') || exit;
$dots_image_url = get_template_directory_uri() . '/assets/images/dots-one.png';
$background_image_url = get_template_directory_uri() . '/assets/images/main-background-image.png';
try {
    if(is_rtl()){
        $logo_image_url = OptionLogic::getSafeImageUrl(OptionController::getOptionValue('general-logo-image'));
    } else {
        $logo_image_url = OptionLogic::getSafeImageUrl(OptionController::getOptionValue('general-logo-image-ltr'));
    }
} catch (Throwable $e) {
    $logo_image_url = '#';
    error_log($e->getMessage(), E_ERROR);
}


do_action('woocommerce_before_reset_password_form');
?>

    <style>
        #site-header {
            display: none;
        }

        #site-footer {
            display: none;
        }

        .rc-sec-register-sms {
            background-image: url(<?php echo esc_url($background_image_url); ?>);
        }
    </style>


    <section class="rc-sec-register-sms">
        <div class="container position-relative">
            <div class="rc-cm-register-sms-cnt-one d-flex flex-column justify-content-center align-items-center">
                <div class="rc-cm-register-sms-cnt-two d-flex flex-column">


                    <form method="post"
                          class="woocommerce-ResetPassword lost_reset_password bg-primary-register-login rc-cm-register-sms-form d-flex flex-column rounded-4 p-5"
                    >
                        <div class="rc-register-page-logo d-flex justify-content-center">
                            <img class="h-100"
                                 src="<?php echo esc_url($logo_image_url) ?>"
                                 alt=""
                            >
                        </div>

                        <div class="rc-register-page-text mt-4">
                            <p class="text-center">
                                <?php echo apply_filters(
                                    'woocommerce_reset_password_message',
                                    esc_html__('Enter a new password below.', 'woocommerce')
                                ); ?>
                            </p><?php // @codingStandardsIgnoreLine ?>
                        </div>

                        <div
                            class="woocommerce-form-row woocommerce-form-row--first form-row rc-register-page-input-pass mt-3 rc-register-page-input-text d-flex align-items-center px-3 rounded-3 overflow-hidden"
                        >
                            <label for="password_1"
                                   hidden
                            >
                                <?php esc_html_e('New password', 'woocommerce'); ?>
                                <span class="required">*</span>
                            </label>

                            <input class="woocommerce-Input woocommerce-Input--text input-text w-100 py-3"
                                   type="password"
                                   name="password_1"
                                   id="password_1"
                                   autocomplete="new-password"
                                   placeholder="<?php esc_html_e('New password', 'woocommerce'); ?>"
                            >

                        </div>

                        <div
                            class="woocommerce-form-row woocommerce-form-row--last form-row rc-register-page-input-pass mt-3 rc-register-page-input-text d-flex align-items-center px-3 rounded-3 overflow-hidden"
                        >
                            <label for="password_2" hidden>
                                <?php esc_html_e('Re-enter new password', 'woocommerce'); ?>
                                &nbsp;<span class="required">*</span>
                            </label>

                            <input class="woocommerce-Input woocommerce-Input--text input-text w-100 py-3"
                                   type="password"
                                   name="password_2"
                                   id="password_2"
                                   autocomplete="new-password"
                                   placeholder="<?php esc_html_e('Re-enter new password', 'woocommerce'); ?>"
                            >

                        </div>

                        <div class="clear"></div>

                        <?php do_action('woocommerce_resetpassword_form'); ?>
                        <input type="hidden" name="reset_key" value="<?php echo esc_attr($args['key']); ?>"/>
                        <input type="hidden" name="reset_login" value="<?php echo esc_attr($args['login']); ?>"/>


                        <div class="rc-register-sms-btns d-flex w-100 gap-3 mt-4">
                            <input type="hidden" name="wc_reset_password" value="true"/>
                            <button type="submit"
                                    class="rc-register-sms-btn-complete-registration rc-register-sms-btn bg-secondary-600 px-4 py-3 w-50 d-flex justify-content-center rounded-3 text-white woocommerce-Button button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"
                                    value="<?php esc_attr_e('Save', 'woocommerce'); ?>"
                            >
                                <?php esc_html_e('Save', 'woocommerce'); ?>
                            </button>
                        </div>


                        <?php wp_nonce_field('reset_password', 'woocommerce-reset-password-nonce'); ?>

                    </form>


                    <a href="<?php echo esc_url(home_url()); ?>"
                       class="w-100 text-end pe-5 mt-2 rc-login-form-return-home-link"
                    >
                        <?php echo __('Back to Home', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                    </a>

                </div>
            </div>
            <div class="rc-obj-page-login-register-cnt position-absolute w-100 h-100 top-0">
                <div class="rc-obj-page-login-register-one">
                    <img class="w-100"
                         src="<?php echo esc_url($dots_image_url); ?>"
                         alt=""
                    >
                </div>
                <div class="rc-obj-page-login-register-two">
                    <img class="w-100"
                         src="<?php echo esc_url($dots_image_url); ?>"
                         alt=""
                    >
                </div>
            </div>
        </div>
    </section>
<?php
do_action('woocommerce_after_reset_password_form');

