<?php

/**
 * Register Form
 *
 * This form is same as login form with the default actions
 * But it shows the registration form.
 * It's a custom separate registration which comes from form-login.php
 *
 * @Package AstarehTheme
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use RTLPlugins\AstarehCore\Admin\OptionLogic;
use RTLPlugins\AstarehCore\Controllers\OptionController;

$dots_image_url = get_template_directory_uri() . '/assets/images/dots-one.png';
$background_image_url = get_template_directory_uri() . '/assets/images/main-background-image.png';
try {
    if (is_rtl()) {
        $logo_image_url = OptionLogic::getSafeImageUrl(OptionController::getOptionValue('general-logo-image'));
    } else {
        $logo_image_url = OptionLogic::getSafeImageUrl(OptionController::getOptionValue('general-logo-image-ltr'));
    }
} catch (Throwable $e) {
    $logo_image_url = '';
    error_log($e->getMessage(), E_ERROR);
}


remove_action('woocommerce_register_form', 'wc_registration_privacy_policy_text', 20);
?>

<?php if ('yes' !== get_option('woocommerce_enable_myaccount_registration')) {
    return null;
}
?>
<style>
    #site-header {
        display: none;
    }

    #site-footer {
        display: none;
    }

    .rc-sec-register-form {
        background-image: url(<?php echo esc_url($background_image_url); ?>);
    }
</style>


<section class="rc-sec-register-form">
    <div class="container position-relative">

        <div class="rc-cm-register-form-cnt-one d-flex flex-column justify-content-center align-items-center">
            <div class="rc-cm-register-form-cnt-two d-flex flex-column">
                <?php do_action('woocommerce_before_customer_login_form'); ?>

                <form method="post"
                      class="woocommerce-form woocommerce-form-register register bg-primary-register-login rc-cm-register-form d-flex flex-column rounded-4 p-5"
                    <?php do_action('woocommerce_register_form_tag'); ?>
                >
                    <div class="rc-register-page-logo d-flex justify-content-center">
                        <img class="h-100"
                             src="<?php echo esc_url($logo_image_url) ?>"
                             alt=""
                        >
                    </div>

                    <div class="rc-register-page-text mt-4">
                        <p class="text-center">
                            <?php echo __('Please complete this form to join the portal.', _get_theme_constant('THEME_TEXTDOMAIN')) ?>
                        </p>
                    </div>

                    <?php do_action('woocommerce_register_form_start'); ?>

                    <!--Start register page inputs-->
                    <div class="rc-register-page-inputs d-flex flex-column w-100 mt-3">


                        <!--USERNAME-->
                        <?php if ('no' === get_option('woocommerce_registration_generate_username')) : ?>
                            <div
                                class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide rc-register-page-input-username rc-register-page-input-text d-flex align-items-center px-3 rounded-3 overflow-hidden mt-3"
                            >
                                <label class="sr-only hidden"
                                       for="reg_username"
                                >
                                    <?php esc_html_e('Username', 'woocommerce'); ?>&nbsp;
                                    <span class="required">*</span>
                                </label>

                                <input class="w-100  py-3 woocommerce-Input woocommerce-Input--text input-text"
                                       type="text"
                                       name="username"
                                       id="reg_username" autocomplete="username"
                                       placeholder="<?php esc_html_e('Username', 'woocommerce'); ?>"
                                       value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>"
                                ><?php // @codingStandardsIgnoreLine ?>
                                <div class="rc-icon-input ms-auto">
                                    <i class="iconsax-outline-user text-lg color-secondary-500"></i>
                                </div>
                            </div>
                        <?php endif; ?>


                        <!--EMAIL-->
                        <div
                            class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide rc-register-page-input-username rc-register-page-input-text d-flex align-items-center px-3 rounded-3 overflow-hidden mt-3"
                        >
                            <label for="reg_email" class="sr-only hidden">
                                <?php esc_html_e('Email address', 'woocommerce'); ?>
                                <span class="required">*</span>
                            </label>

                            <input class="w-100  py-3 woocommerce-Input woocommerce-Input--text input-text"
                                   name="email"
                                   id="reg_email"
                                   autocomplete="email"
                                   type="email"
                                   placeholder="<?php esc_html_e('Email address', 'woocommerce'); ?>"
                                   value="<?php echo (!empty($_POST['email'])) ? esc_attr(wp_unslash($_POST['email'])) : ''; ?>"
                            ><?php // @codingStandardsIgnoreLine ?>

                            <div class="rc-icon-input ms-auto">
                                <i class="iconsax-outline-sms text-lg color-secondary-600"></i>
                            </div>
                        </div>


                        <!--PASSWORD-->
                        <?php if ('no' === get_option('woocommerce_registration_generate_password')) : ?>
                            <div
                                class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide rc-register-page-input-pass mt-3 rc-register-page-input-text d-flex align-items-center px-3 rounded-3 overflow-hidden"
                            >
                                <label for="reg_password"
                                       class="sr-only hidden"
                                >
                                    <?php esc_html_e('Password', 'woocommerce'); ?>
                                    <span class="required">*</span>
                                </label>

                                <input class="woocommerce-Input woocommerce-Input--text input-text w-100 py-3"
                                       type="password"
                                       id="reg_password"
                                       name="password"
                                       autocomplete="new-password"
                                       placeholder="<?php esc_html_e('Password', 'woocommerce'); ?>"
                                >

                            </div>

                        <?php else : ?>

                            <div class="w-100 py-3">
                                <?php esc_html_e('A link to set a new password will be sent to your email address.', 'woocommerce'); ?>
                            </div>

                        <?php endif; ?>


                        <div class="rc-register-page-rules d-flex mt-3 form-row privacy-policy-text">
                            <input type="checkbox" class="woocommerce-form__input woocommerce-form__input-checkbox"
                                   name="privacy_policy" id="privacy_policy">
                            <label for="privacy_policy"
                                   class="woocommerce-form__label woocommerce-form__label-for-checkbox inline ms-2">
                                <?php printf(__('I have read and agree to the <a href="%s" class="text-white text-decoration-underline" target="_blank">privacy policy</a>', _get_theme_constant('THEME_TEXTDOMAIN')),
                                    esc_url(get_permalink(wc_get_page_id('privacy-policy'))));
                                ?>
                            </label>
                            <br>
                        </div>

                        <?php do_action('woocommerce_register_form'); ?>

                    </div><!--.rc-register-page-inputs-->

                    <div class="woocommerce-form-row form-row rc-register-page-btns d-flex w-100 gap-3 mt-4">
                        <?php wp_nonce_field('woocommerce-register', 'woocommerce-register-nonce'); ?>
                        <button type="submit"
                                class="woocommerce-Button <?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?> woocommerce-form-register__submit rc-register-page-btn-send-sms rc-register-page-btn-register bg-secondary-600 px-4 py-3 w-50 d-flex justify-content-center rounded-3 text-white text-lg"
                                name="register"
                                value="<?php esc_attr_e('Register', 'woocommerce'); ?>"><?php esc_html_e('Register', 'woocommerce'); ?>
                        </button>
                    </div>

                    <?php do_action('woocommerce_register_form_end'); ?>

                </form>

                <a href="<?php echo esc_url(home_url()); ?>"
                   class="w-100 text-end pe-5 mt-2 rc-register-form-return-home-link"
                >
                    <?php echo __('Back to Home', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                </a>

                <?php do_action('woocommerce_after_customer_login_form'); ?>


            </div>


            <div class="rc-obj-page-login-register-cnt position-absolute w-100 h-100 top-0">
                <div class="rc-obj-page-login-register-one">
                    <img class="w-100" src="<?php echo esc_url($dots_image_url); ?>" alt="">
                </div>
                <div class="rc-obj-page-login-register-two">
                    <img class="w-100" src="<?php echo esc_url($dots_image_url); ?>" alt="">
                </div>
            </div>


        </div>
</section>