<?php

/**
 * Lost password form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-lost-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version  9.2.0
 */


use RTLPlugins\AstarehCore\Admin\OptionLogic;
use RTLPlugins\AstarehCore\Controllers\OptionController;

defined('ABSPATH') || exit;

$dots_image_url = get_template_directory_uri() . '/assets/images/dots-one.png';
$background_image_url = get_template_directory_uri() . '/assets/images/main-background-image.png';
try {
    if(is_rtl()){
        $logo_image_url = OptionLogic::getSafeImageUrl(OptionController::getOptionValue('general-logo-image'));
    } else {
        $logo_image_url = OptionLogic::getSafeImageUrl(OptionController::getOptionValue('general-logo-image-ltr'));
    }

} catch (Throwable $e) {
    $logo_image_url = '#';
    error_log($e->getMessage(), E_ERROR);
}



?>
    <style>
        #site-header {
            display: none;
        }

        #site-footer {
            display: none;
        }

        .rc-sec-register-sms {
            background-image: url("<?php echo esc_url($background_image_url); ?>");
        }
    </style>


    <section class="rc-sec-register-sms">
        <div class="container position-relative">
            <div class="rc-cm-register-sms-cnt-one d-flex flex-column justify-content-center align-items-center">
                <div class="rc-cm-register-sms-cnt-two d-flex flex-column">
                    <?php do_action('woocommerce_before_lost_password_form'); ?>
                    <form method="post"
                          class="woocommerce-ResetPassword lost_reset_password bg-primary-register-login rc-cm-register-sms-form d-flex flex-column bg-primary-600 rounded-4 p-5"
                    >
                        <div class="rc-register-sms-logo d-flex justify-content-center">
                            <img class="h-100"
                                 src="<?php echo esc_url($logo_image_url) ?>"
                                 alt=""
                            >
                        </div>

                        <div class="rc-register-sms-text mt-4 text-center">
                            <p>
                                <?php echo apply_filters(
                                    'woocommerce_lost_password_message',
                                    esc_html__('Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'woocommerce')
                                ); ?>
                            </p><?php // @codingStandardsIgnoreLine ?>
                        </div>


                        <div class="rc-register-sms-inputs d-flex flex-column w-100 mt-3">

                            <div
                                class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first rc-register-sms-input-user-code rc-register-sms-input-text d-flex align-items-center px-3 rounded-3 overflow-hidden mt-3 w-100">
                                <label for="user_login" hidden>
                                    <?php esc_html_e('Username or email', 'woocommerce'); ?>
                                </label>

                                <input class="woocommerce-Input woocommerce-Input--text input-text w-100  py-3"
                                       type="text"
                                       name="user_login"
                                       id="user_login"
                                       autocomplete="username"
                                       placeholder="<?php esc_html_e('Username or email', 'woocommerce'); ?>"
                                >
                                <div class="rc-icon-input ms-auto">
                                    <i class="iconsax-outline-sms-tracking text-lg color-secondary-600"></i>
                                </div>
                            </div>

                            <div class="clear"></div>

                            <?php do_action('woocommerce_lostpassword_form'); ?>
                        </div><!--.rc-register-sms-inputs-->


                        <!--Submit Button-->
                        <div class="rc-register-sms-btns d-flex w-100 gap-3 mt-4 woocommerce-form-row form-row">
                            <input type="hidden" name="wc_reset_password" value="true"/>
                            <button type="submit"
                                    class="text-white woocommerce-Button <?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?> rc-register-sms-btn-complete-registration rc-register-sms-btn bg-secondary-600 px-4 py-3 w-50 d-flex justify-content-center rounded-3"
                                    value="<?php esc_attr_e('Reset password', 'woocommerce'); ?>"
                            >
                                <?php esc_html_e('Reset password', 'woocommerce'); ?>
                            </button>

                        </div>
                        <!--End Submit button-->


                        <?php wp_nonce_field('lost_password', 'woocommerce-lost-password-nonce'); ?>

                    </form>
                    <!--End Lost Password Form-->

                    <a href="<?php echo esc_url(home_url()); ?>"
                       class="w-100 text-end pe-5 mt-2 rc-register-sms-return-home-link"
                    >
                        <?php echo __('Back to Home', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                    </a>
                </div>
            </div>
            <div class="rc-obj-page-login-register-cnt position-absolute w-100 h-100 top-0">
                <div class="rc-obj-page-login-register-one">
                    <img class="w-100"
                         src="<?php echo esc_url($dots_image_url); ?>"
                         alt=""
                    >
                </div>
                <div class="rc-obj-page-login-register-two">
                    <img class="w-100"
                         src="<?php echo esc_url($dots_image_url); ?>"
                         alt=""
                    >
                </div>
            </div>
        </div>
    </section>
<?php
do_action('woocommerce_after_lost_password_form');
