<?php

/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.9.0
 */

use RTLPlugins\AstarehCore\Admin\OptionLogic;
use RTLPlugins\AstarehCore\Controllers\OptionController;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$dots_image_url = get_template_directory_uri() . '/assets/images/dots-one.png';
$background_image_url = get_template_directory_uri() . '/assets/images/main-background-image.png';


$register_page_url = (function_exists('astareh_wc_get_register_url') && 'yes' === get_option('woocommerce_enable_myaccount_registration'))
    ? astareh_wc_get_register_url()
    : '';
try {
    if (is_rtl()) {
        $logo_image_url = OptionLogic::getSafeImageUrl(OptionController::getOptionValue('general-logo-image'));
    } else {
        $logo_image_url = OptionLogic::getSafeImageUrl(OptionController::getOptionValue('general-logo-image-rtl'));
    }
} catch (Throwable $e) {
    $logo_image_url = '#';
    error_log($e->getMessage(), E_ERROR);
}
?>

<style>
    #site-header {
        display: none;
    }

    #site-footer {
        display: none;
    }

    .rc-sec-login-form {
        background-image: url(<?php echo esc_url($background_image_url); ?>);
    }
</style>


<section class="rc-sec-login-form">
    <div class="container position-relative">
        <div class="rc-cm-login-form-cnt-one d-flex flex-column justify-content-center align-items-center">
            <div class="rc-cm-login-form-cnt-two d-flex flex-column">
                <?php do_action('woocommerce_before_customer_login_form'); ?>
                <!--Login Form-->
                <form
                    class="woocommerce-form woocommerce-form-login login bg-primary-register-login rc-cm-login-form d-flex flex-column rounded-4 p-5"
                    method="post"
                >

                    <!--Logo-->
                    <div class="rc-login-page-logo d-flex justify-content-center">
                        <img class="h-100"
                             src="<?php echo esc_url($logo_image_url) ?>"
                             alt=""
                        >
                    </div>
                    <!--End Logo-->

                    <!--Hint-->
                    <div class="rc-login-page-text mt-4">
                        <p class="text-center">
                            <?php echo __('Enter username and password to login.', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                        </p>
                    </div>
                    <!--End Hint-->

                    <?php do_action('woocommerce_login_form_start'); ?>

                    <div class="rc-login-page-inputs d-flex flex-column w-100 mt-3">
                        <!--Username Field-->
                        <div
                            class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide rc-login-page-input-username rc-login-page-input-text d-flex align-items-center px-3 rounded-3 overflow-hidden mt-3">
                            <label for="username" hidden>
                                <?php esc_html_e('Username or email address', 'woocommerce'); ?>
                                <span class="required">*</span>
                            </label>

                            <input class="w-100  py-3 woocommerce-Input woocommerce-Input--text input-text"
                                   type="text"
                                   name="username"
                                   placeholder="<?php esc_html_e('Username or email address', 'woocommerce'); ?>"
                                   autocomplete="username"
                                   id="username"
                                   value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>"
                            /><?php // @codingStandardsIgnoreLine ?>

                            <div class="rc-icon-input ms-auto">
                                <i class="iconsax-outline-sms text-lg color-secondary-600"></i>
                            </div>
                        </div>
                        <!--End Username Field-->


                        <!--Password Field-->
                        <div
                            class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide rc-login-page-input-pass mt-4 rc-login-page-input-text d-flex align-items-center px-3 rounded-3 overflow-hidden">
                            <label for="password" hidden>
                                <?php esc_html_e('Password', 'woocommerce'); ?>
                                <span class="required">*</span>
                            </label>

                            <input class="woocommerce-Input woocommerce-Input--text input-text w-100 py-3"
                                   type="password"
                                   name="password"
                                   id="password"
                                   placeholder="<?php esc_html_e('Password', 'woocommerce'); ?>"
                                   autocomplete="current-password"
                            >
                        </div>
                        <!--End Password Field-->

                    </div><!--.rc-login-page-inputs-->

                    <?php do_action('woocommerce_login_form'); ?>


                    <!--Remember me and Forgot password link-->
                    <div class="rc-login-page-remember-me-forget-pass d-flex mt-3">

                        <div class="form-row rc-login-page-remember-me d-flex">
                            <input type="checkbox"
                                   name="rememberme"
                                   id="rememberme"
                                   value="forever"
                                   class="woocommerce-form__input woocommerce-form__input-checkbox"
                            >
                            <label
                                class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme ms-2"
                                for="rememberme"
                            >
                                <?php esc_html_e('Remember me', 'woocommerce'); ?>
                            </label>
                            <br>
                        </div>

                        <div class="woocommerce-LostPassword lost_password rc-login-page-forget-pass ms-auto">
                            <a href="<?php echo esc_url(wp_lostpassword_url()); ?>"
                               class="text-white text-decoration-underline"
                            >
                                <?php esc_html_e('Lost your password?', 'woocommerce'); ?>
                            </a>
                        </div>

                    </div>
                    <!--End Remember me and Forgot password link-->

                    <?php if (!empty($register_page_url)): ?>
                        <!--Create Account Link-->
                        <div class="rc-login-page-register-link mt-5">
                            <span>
                                <?php echo __('You are not registered?', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                            </span>
                            <a href="<?php echo esc_url($register_page_url); ?>"
                               class="ms-2 text-white text-decoration-underline">
                                <?php echo __("Register", _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                            </a>
                        </div>
                        <!--End Create Account Link-->
                    <?php endif; ?>

                    <div class="rc-login-page-btns d-flex w-100 gap-3 mt-4">

                        <?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>
                        <button type="submit"
                                class="text-white rc-login-page-btn-login-wp rc-login-page-btn-login bg-secondary-600 px-4 py-3 w-50 d-flex justify-content-center rounded-3  woocommerce-button woocommerce-form-login__submit<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"
                                name="login"
                                value="<?php esc_attr_e('Log in', 'woocommerce'); ?>">
                            <?php esc_html_e('Log in', 'woocommerce'); ?>
                        </button>

                    </div>


                    <?php do_action('woocommerce_login_form_end'); ?>

                </form>
                <!--End Login Form-->

                <a href="<?php echo esc_url(home_url()); ?>"
                   class="w-100 text-end pe-5 mt-2 rc-login-form-return-home-link"
                >
                    <?php echo __('Back to Home', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                </a>

            </div>
        </div>
        <div class="rc-obj-page-login-register-cnt position-absolute w-100 h-100 top-0">
            <div class="rc-obj-page-login-register-one">
                <img class="w-100"
                     src="<?php echo esc_url($dots_image_url); ?>"
                     alt=""
                >
            </div>
            <div class="rc-obj-page-login-register-two">
                <img class="w-100"
                     src="<?php echo esc_url($dots_image_url); ?>"
                     alt=""
                >
            </div>
        </div>
    </div>
</section>

<?php do_action('woocommerce_after_customer_login_form'); ?>

