<?php
/**
 * Edit account form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-edit-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_edit_account_form'); ?>

<div class="rc-woo-user-panel-user-profile-content w-100">
    <form
        class="woocommerce-EditAccountForm edit-account rc-woo-user-panel-user-panel-user-profile-fields d-flex flex-column"
        action=""
        method="post" <?php do_action('woocommerce_edit_account_form_tag'); ?> >

        <?php do_action('woocommerce_edit_account_form_start'); ?>

        <!--Account Information-->
        <div class="rc-woo-user-panel-profile-fields-part-one d-flex flex-column w-100">
            <div class="rc-woo-user-panel-user-profile-sec-title mb-5">
                <a class="text-semibold text-lg color-primary-100">
                    <?php echo __('Change Account Information', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                </a>
            </div>

            <div class="row gy-4">

                <!--Name-->
                <div class="col-md-4 col-12">
                    <div class="rc-woo-user-panel-input-cnt d-flex flex-column">
                        <label
                            for="account_first_name"
                            class="rc-woo-user-panel-input-label text-sm ps-3" for="rc-woo-user-panel-input-user-name"
                        >
                            <?php esc_html_e('First name', 'woocommerce'); ?>
                        </label>
                        <div class="rc-woo-user-panel-input d-flex mt-2 bg-primary-500  rounded-3 overflow-hidden">
                            <input type="text"
                                   class="woocommerce-Input woocommerce-Input--text input-text w-100"
                                   name="account_first_name"
                                   id="account_first_name"
                                   autocomplete="given-name"
                                   value="<?php echo esc_attr($user->first_name); ?>"
                            >
                        </div>
                    </div>
                </div>
                <!--Family-->
                <div class="col-md-4 col-12">
                    <div class="rc-woo-user-panel-input-cnt d-flex flex-column">
                        <label class="rc-woo-user-panel-input-label text-sm ps-3"
                               for="account_last_name"
                        >
                            <?php esc_html_e('Last name', 'woocommerce'); ?>
                        </label>
                        <div class="rc-woo-user-panel-input d-flex mt-2 bg-primary-500  rounded-3 overflow-hidden">
                            <input type="text"
                                   class="woocommerce-Input woocommerce-Input--text input-text w-100"
                                   name="account_last_name"
                                   id="account_last_name"
                                   autocomplete="family-name"
                                   value="<?php echo esc_attr($user->last_name); ?>"
                            >
                        </div>
                    </div>
                </div>
                <!--Display Name-->
                <div class="col-md-4 col-12">
                    <div class="rc-woo-user-panel-input-cnt d-flex flex-column">
                        <label class="rc-woo-user-panel-input-label text-sm ps-3"
                               for="account_display_name"
                        >
                            <?php esc_html_e('Display name', 'woocommerce'); ?>
                        </label>
                        <div class="rc-woo-user-panel-input d-flex mt-2 bg-primary-500  rounded-3 overflow-hidden">
                            <input type="text"
                                   class="woocommerce-Input woocommerce-Input--text input-text w-100"
                                   name="account_display_name"
                                   id="account_display_name"
                                   value="<?php echo esc_attr($user->display_name); ?>"
                            >
                        </div>
                    </div>
                </div>

                <!--Email-->
                <div class="col-12">
                    <div class="rc-woo-user-panel-input-cnt d-flex flex-column">
                        <label class="rc-woo-user-panel-input-label text-sm ps-3"
                               for="account_email"
                        >
                            <?php esc_html_e('Email address', 'woocommerce'); ?>
                        </label>
                        <div class="rc-woo-user-panel-input d-flex mt-2 bg-primary-500  rounded-3 overflow-hidden">
                            <input
                                type="email"
                                class="w-100 woocommerce-Input woocommerce-Input--email input-text w-100"
                                name="account_email"
                                id="account_email"
                                autocomplete="email"
                                value="<?php echo esc_attr($user->user_email); ?>"
                            >
                        </div>
                    </div>
                </div>


            </div>


        </div>


        <!--Account Password-->
        <div class="rc-woo-user-panel-profile-fields-part-two d-flex flex-column w-100 mt-5">
            <div class="rc-woo-user-panel-user-profile-sec-title mb-4">
                <a class="text-semibold text-lg color-primary-100">
                    <?php esc_html_e('Password change', 'woocommerce'); ?>
                </a>
            </div>

            <div class="row gy-4">

                <div class="col-md-4 col-12">
                    <div
                        class="rc-woo-user-panel-input-cnt d-flex flex-column woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                        <label class="rc-woo-user-panel-input-label text-sm ps-3"
                               for="password_current"
                        >
                            <?php esc_html_e('Current password (leave blank to leave unchanged)', 'woocommerce'); ?>
                        </label>
                        <div
                            class="rc-woo-user-panel-input d-flex mt-2 bg-primary-500 rounded-3 overflow-hidden woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                            <input type="password"
                                   class="woocommerce-Input woocommerce-Input--password input-text"
                                   name="password_current"
                                   id="password_current"
                                   autocomplete="off"
                            >
                        </div>
                    </div>
                </div>

                <div class="col-md-4 col-12">
                    <div
                        class="rc-woo-user-panel-input-cnt d-flex flex-column woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                        <label class="rc-woo-user-panel-input-label text-sm ps-3"
                               for="password_1"
                        >
                            <?php esc_html_e('New password (leave blank to leave unchanged)', 'woocommerce'); ?>
                        </label>
                        <div
                            class="rc-woo-user-panel-input d-flex mt-2 bg-primary-500 rounded-3 overflow-hidden woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                            <input type="password"
                                   class="woocommerce-Input woocommerce-Input--password input-text"
                                   name="password_1"
                                   id="password_1"
                                   autocomplete="off"
                            >
                        </div>
                    </div>
                </div>

                <div class="col-md-4 col-12">
                    <div
                        class="rc-woo-user-panel-input-cnt d-flex flex-column woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                        <label class="rc-woo-user-panel-input-label text-sm ps-3"
                               for="password_2"
                        >
                            <?php esc_html_e('Confirm new password', 'woocommerce'); ?>
                        </label>
                        <div
                            class="rc-woo-user-panel-input d-flex mt-2 bg-primary-500 rounded-3 overflow-hidden woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                            <input type="password"
                                   class="woocommerce-Input woocommerce-Input--password input-text"
                                   name="password_2"
                                   id="password_2"
                                   autocomplete="off"
                            >
                        </div>
                    </div>
                </div>


            </div>
        </div>

        <?php do_action('woocommerce_edit_account_form'); ?>

        <div class="rc-woo-user-panel-profile-btn-save mt-5 ms-auto">
            <?php wp_nonce_field('save_account_details', 'save-account-details-nonce'); ?>
            <input type="hidden" name="action" value="save_account_details"/>
            <button type="submit"
                    class="px-5 py-3 bg-secondary-500 rounded-3 woocommerce-Button button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"
                    name="save_account_details"
                    value="<?php esc_attr_e('Save changes', 'woocommerce'); ?>"
            >
                <?php esc_html_e('Save changes', 'woocommerce'); ?>
            </button>
        </div>

        <?php do_action('woocommerce_edit_account_form_end'); ?>
    </form>
</div>

<?php do_action('woocommerce_after_edit_account_form'); ?>
