<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$allowed_html = [
    'a' => [
        'href' => [],
    ],
];
?>


    <div class="rc-woo-user-panel-wlm-user-cnt d-flex flex-column justify-content-center">

        <div class="rc-woo-user-panel-wlm-user d-flex justify-content-center">
            <span class="text-lg color-secondary-600">
                <?php echo __('Hello', _get_theme_constant('THEME_TEXTDOMAIN')) ?>
            </span>
            <span class="ms-1 text-lg color-secondary-600">
                <?php echo esc_html($current_user->display_name); ?>
        </div>


        <p class="mt-3 text-center w-lg-75 w-90 m-auto">
            <?php echo __(
                'By accessing your user account dashboard, you can view your recent activities, see your purchased products, and also download your downloaded files again. You will also be able to edit your account details and password.',
                _get_theme_constant('THEME_TEXTDOMAIN')
            ) ?>
        </p>


        <?php
        /**
         * My Account dashboard.
         *
         * @since 2.6.0
         */
        do_action('woocommerce_account_dashboard');
        ?>

    </div>
<?php

/**
 * Deprecated woocommerce_before_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_before_my_account');

/**
 * Deprecated woocommerce_after_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_after_my_account');

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */

