<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

use RTLPlugins\AstarehCore\Controllers\OptionController;
use RTLPlugins\AstarehCore\Controllers\PostTypeController;
use RTLPlugins\AstarehCore\Helper as CoreHelper;

wp_enqueue_style(__THEME_PREFIX.'swiper-bundle');
wp_enqueue_script(__THEME_PREFIX.'swiper-bundle');
wp_enqueue_script(__THEME_PREFIX.'single-product');

$date_icon = get_template_directory_uri() . '/assets/images/date.svg';
$comments_icon = get_template_directory_uri() . '/assets/images/comments.svg';
$view_icon = get_template_directory_uri() . '/assets/images/view-icon.svg';
$author_icon = get_template_directory_uri() . '/assets/images/author.svg';
$share_icon = get_template_directory_uri() . '/assets/images/icon-share.svg';
$calendar_icon = get_template_directory_uri() . '/assets/images/calendar-small-icon.svg';
$like_icon = get_template_directory_uri() . '/assets/images/like.svg';


$user_ip = isset( $_SERVER['REMOTE_ADDR'] ) ? $_SERVER['REMOTE_ADDR'] : 'UNKNOWN';
$key = $user_ip . '__' . get_the_ID();
$value = [ $user_ip, get_the_ID() ];
$visited = get_transient( $key );
if ( empty( $visited ) ) {
	set_transient( $key, $value, 60 * 60 * 12 );
	$count_key = 'astareh_views';
	$count = get_post_meta( get_the_ID(), $count_key, true );
	if ( $count == '' ) {
		$count = 0;
		delete_post_meta( get_the_ID(), $count_key );
		add_post_meta( get_the_ID(), $count_key, $count );
	} else {
		$count++;
		update_post_meta( get_the_ID(), $count_key, $count );
	}
}

$count_key = 'astareh_views';
$count = get_post_meta( get_the_ID(), $count_key, true );
if ( $count == '' ) {
	delete_post_meta( get_the_ID(), $count_key );
	add_post_meta( get_the_ID(), $count_key, '0' );
	$count = '0';
}

$view_count = $count;

/*COUNT THE APPROVED COMMENTS*/
$comment_count = get_comment_count( get_the_ID() )['approved'];

/*GET THE POST AUTHOR*/
$author = get_the_author_meta( 'nickname' );


$publish_date = the_date( 'Y/m/d', '', '', false );
if ( is_rtl() && function_exists( 'jdate' ) ) {
	$time_stamp = strtotime( $publish_date );
	$publish_date = jdate( $publish_date )->format( 'Y/m/d' );
}

if (function_exists('astareh_breadcrumb')) {
    astareh_breadcrumb();
}

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action('woocommerce_before_single_product');


if (post_password_required()) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}

try {
    $enable_related_products = OptionController::getOptionValue('shop-single-related-products', false);
} catch (Throwable $e) {
    $enable_related_products = false;
    error_log($e->getMessage(), E_ERROR);
}

if (!$enable_related_products) {
    remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
}
?>

<section id="product-<?php the_ID(); ?>" <?php wc_product_class('single-product mt-5', $product); ?>>
    <div class="container-fluid container-md">
        <div class="single-product-cnt d-flex flex-column">
            <div
				class="title-box-1 p-3 rounded-3 bg-primary-600 d-flex flex-column flex-lg-row align-items-lg-center mb-4">
				<div class="title">
					<h1 class="color-secondary-600 entry-title text-lg">
						<?php the_title() ?>
					</h1>
				</div>
				<div class="left ms-lg-auto d-flex flex-column flex-lg-row align-items-lg-center">
					<div class="date item-left d-flex ps-lg-3 py-2">
						<div class="item-left-icon me-2">
							<img class="w-100" src="<?php echo esc_url( $date_icon ) ?>" alt="">
						</div>
						<span class="color-primary-200">
							<?php echo esc_html( $publish_date ); ?>
			
						</span>
					</div>
					<div class="comments item-left d-flex ps-lg-3 ms-lg-4 py-2">
						<div class="item-left-icon me-2">
							<img class="w-100" src="<?php echo esc_url( $comments_icon ); ?>" alt="">
						</div>
						<a href="#comments">
							<?php
							printf(
								__( '%1s Comments', _get_theme_constant( 'THEME_TEXTDOMAIN' ) ),
								$comment_count
							);
							?>
						</a>
					</div>
					<div class="view item-left d-flex ps-lg-3 ms-lg-4 py-2">
						<div class="item-left-icon me-2">
							<img class="w-100" src="<?php echo esc_url( $view_icon ) ?>" alt="">
						</div>
						<span class="color-primary-200">
							<?php
							printf(
								__( '%1s Views', _get_theme_constant( 'THEME_TEXTDOMAIN' ) ),
								$view_count
							);
							?>
						</span>
					</div>
					<div class="author item-left mx-lg-4 d-flex ps-lg-3 py-2">
						<div class="item-left-icon me-2">
							<img class="w-100" src="<?php echo esc_url( $author_icon ) ?>" alt="">
						</div>
						<span class="color-primary-200">
							<?php echo esc_html( $author ) ?>
						</span>
					</div>
					<?php get_template_part( 'template-parts/share-box' ) ?>
                </div>
            </div>

            <div class="rc-head-product-cnt bg-primary-600 rounded-4 d-flex flex-column flex-lg-row">
                <div class="rc-head-product-right w-100 w-lg-50">

                    <div class="rc-cm-slider-1 position-relative">
                        <div class="rc-slider-cnt">
                            <!--SECTION OF IMAGE AND PRODUCT SUMMARY-->

                            <?php
                            /**
                             * Hook: woocommerce_before_single_product_summary.
                             *
                             * @hooked woocommerce_show_product_sale_flash - 10
                             * @hooked woocommerce_show_product_images - 20
                             */
                            do_action('woocommerce_before_single_product_summary');
                            ?>
                        </div>
                        <div class="rc-cm-slider-1-bg position-absolute w-100 bg-primary-600 top-0 rounded-4"></div>
                    </div>
                </div>


                <div class="rc-head-product-left w-100 w-lg-50 d-flex flex-column px-lg-5 px-md-4 pb-0 mt-lg-0 mt-3">

                    <?php
                    /**
                     * Hook: woocommerce_single_product_summary.
                     *
                     * @hooked woocommerce_template_single_title - 5
                     * @hooked woocommerce_template_single_rating - 10
                     * @hooked woocommerce_template_single_price - 10
                     * @hooked woocommerce_template_single_excerpt - 20
                     * @hooked woocommerce_template_single_add_to_cart - 30
                     * @hooked woocommerce_template_single_meta - 40
                     * @hooked woocommerce_template_single_sharing - 50
                     * @hooked WC_Structured_Data::generate_product_data() - 60
                     */
                    do_action('woocommerce_single_product_summary');
                    ?>


                </div>
            </div>

        </div>
    </div><!--.container-->
    <?php
    /**
     * Hook: woocommerce_after_single_product_summary.
     *
     * @hooked woocommerce_output_product_data_tabs - 10
     * @hooked woocommerce_upsell_display - 15
     * @hooked woocommerce_output_related_products - 20
     */
    do_action('woocommerce_after_single_product_summary');
    ?>

    <?php do_action('woocommerce_after_single_product'); ?>

</section> <!--.single-product-->
<?php
comments_template();
?>
