<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

use RTLPlugins\AstarehCore\Controllers\OptionController;

defined('ABSPATH') || exit;

global $product;

// Ensure visibility.
if (empty($product) || !$product->is_visible()) {
    return;
}


/**
 * Remove default actions in woocommerce shop archive.
 * it doesn't need to be in functions, because we are not override the methods.
 */
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);
remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);


//Product url
$product_link = apply_filters('woocommerce_loop_product_link', get_the_permalink(), $product);
//Product image html
$image_size = apply_filters('single_product_archive_thumbnail_size', [400,200] );
$product_image = $product->get_image($image_size, ['class' => 'w-100']);
//Product title
$product_title = $product->get_title();

//Product parent categories
$categories = get_the_terms($product->get_id(), 'product_cat');
$parent_categories = [];
if ($categories && !is_wp_error($categories)) {
    $parent_categories = array_filter($categories, function ($item) {
        return $item->parent === 0;
    });
}
$parent_categories_count = count($parent_categories);
try {
    $separator = OptionController::getOptionValue('general-options-category-separator-ltr');
    if (is_rtl()) {
        $separator = OptionController::getOptionValue('general-options-category-separator-rtl');
    }
} catch (Throwable $e) {
    $separator = ',';
    error_log($e->getMessage(), E_ERROR);
}

//Product price
$product_regular_price = (float)$product->get_regular_price();
$product_sale_price = (float)$product->get_sale_price();

$product_formatted_regular_price = wc_price($product_regular_price);
$product_formatted_sale_price = wc_price($product_sale_price);

if (function_exists('astareh_get_product_discount_percent')) {
    $product_discount_percent = astareh_get_product_discount_percent($product, false);
} else {
    /*It's not percent*/
    $product_discount_percent = $product_regular_price - $product_sale_price;
}
?>

<!--Product Column-->
<div class="col-lg-6 col-12">
    <!--Product Wrapper-->
    <div <?php wc_product_class('rc-product-item d-flex flex-column p-3 rounded-4 bg-primary-600', $product); ?>>
        <?php

        /**
         * Hook: woocommerce_before_shop_loop_item.
         *
         * @hooked woocommerce_template_loop_product_link_open - 10 // DISABLED
         */
        do_action('woocommerce_before_shop_loop_item');

        ?>

        <a href="<?php echo esc_url($product_link); ?>"
           class="rc-product-img d-flex rounded-4 overflow-hidden position-relative woocommerce-LoopProduct-link woocommerce-loop-product__link"
        >
            <!--<div class="rc-product-item-filter position-absolute w-100 h-100 z-1"></div>-->

            <?php
            echo $product_image;
            ?>


            <?php
            /**
             * Hook: woocommerce_before_shop_loop_item_title.
             *
             * @hooked woocommerce_show_product_loop_sale_flash - 10
             * @hooked woocommerce_template_loop_product_thumbnail - 10 // DISABLED
             */
            do_action('woocommerce_before_shop_loop_item_title');
            ?>

        </a><!--.rc-product-img-->


        <?php
        /**
         * Hook: woocommerce_shop_loop_item_title.
         *
         * @hooked woocommerce_template_loop_product_title - 10 // DISABLED
         */
        do_action('woocommerce_shop_loop_item_title');
        ?>

        <div class="rc-product-title mt-4">
            <h3>
                <a href="<?php echo esc_url($product_link); ?>"
                   class="color-secondary-600"
                >
                    <?php echo esc_html($product_title); ?>
                </a>
            </h3>
        </div>


        <div class="rc-product-category mt-2 d-flex">
            <span>
                <?php echo __('Categories :', _get_theme_constant('THEME_TEXTDOMAIN')) ?>
            </span>
            <?php
            foreach (array_values($parent_categories) as $iteration => $category) : ?>
                <a href="<?php echo esc_url(get_term_link($category)) ?>"
                   class="ms-2 text-white"
                >
                    <?php
                    echo ($iteration < $parent_categories_count - 1 && $parent_categories_count > 1)
                        ? esc_html($category->name) . $separator
                        : esc_html($category->name);
                    ?>
                </a>

            <?php endforeach; ?>
        </div>


        <div class="rc-product-item-spacer my-3"></div>


        <div class="post-date-read-more d-flex px-0 px-md-1 px-lg-2 overflow-hidden">

            <?php if (!empty($product_sale_price)): ?>
                <div class="product-off-link-more-cnt me-auto position-relative w-fit">
                    <div
                        class="rc-product-off-link-more rc-product-off-has-offer position-absolute d-flex flex-column w-fit"
                    >
                        <div
                            class="rc-product-off d-flex me-auto flex-column justify-content-center align-items-center mb-auto"
                        >
                            <a>
                                <?php echo esc_html($product_discount_percent) ?>
                            </a>
                        </div>


                        <div
                            class="rc-product-read-more d-flex flex-column justify-content-center align-items-center bg-secondary-600 color-primary-600 rounded-3 px-4 py-3 w-fit"
                        >
                            <?php
                            echo apply_filters(
                                'woocommerce_loop_add_to_cart_link', // WPCS: XSS ok.
                                sprintf(
                                    '<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
                                    esc_url($product->add_to_cart_url()),
                                    esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
                                    esc_attr(isset($args['class']) ? $args['class'] : 'color-primary-600'),
                                    isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
                                    esc_html($product->add_to_cart_text())
                                ),
                                $product,
                                $args
                            );
                            ?>
                        </div>


                    </div>
                </div>
            <?php else : ?>
                <div class="product-off-link-more-cnt me-auto position-relative w-fit mt-5">
                    <div class="rc-product-off-link-more position-absolute d-flex flex-column w-fit  rc-product-off-has-offer mt-4">

                        <div
                            class="rc-product-read-more d-flex flex-column justify-content-center align-items-center bg-secondary-600 rounded-3 px-2 py-2 w-fit"
                        >
                            <?php
                            echo apply_filters(
                                'woocommerce_loop_add_to_cart_link', // WPCS: XSS ok.
                                sprintf(
                                    '<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
                                    esc_url($product->add_to_cart_url()),
                                    esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
                                    esc_attr(isset($args['class']) ? $args['class'] : 'color-primary-600'),
                                    isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
                                    esc_html($product->add_to_cart_text())
                                ),
                                $product,
                                $args
                            );
                            ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (!empty($product_sale_price)) : ?>

                <div class="rc-product-price-off-cnt rc-has-product-off d-flex flex-column justify-content-around">
                    <div class="rc-product-price d-flex flex-column">
                        <a class="ms-auto color-primary-100">
                            <?php echo $product_formatted_regular_price ?>
                        </a>
                    </div>
                    <div class="rc-product-price-off">
                        <p>
                            <?php echo $product_formatted_sale_price ?>
                        </p>
                    </div>
                </div>

            <?php else : ?>
                <div class="rc-product-price-off-cnt d-flex flex-column justify-content-center">

                    <div class="rc-product-price-off">
                        <p>
                            <?php echo $product_formatted_regular_price ?>
                        </p>
                    </div>
                </div>
            <?php endif; ?>


        </div>


        <?php

        /**
         * Hook: woocommerce_after_shop_loop_item_title.
         *
         * @hooked woocommerce_template_loop_rating - 5 // DISABLED
         * @hooked woocommerce_template_loop_price - 10 // DISABLED
         */
        do_action('woocommerce_after_shop_loop_item_title');
        ?>



        <?php
        /**
         * Hook: woocommerce_after_shop_loop_item.
         *
         * @hooked woocommerce_template_loop_product_link_close - 5 // DISABLED
         * @hooked woocommerce_template_loop_add_to_cart - 10 // DISABLED
         */
        do_action('woocommerce_after_shop_loop_item');
        ?>
    </div>

</div>