<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

use RTLPlugins\AstarehCore\Controllers\MetaboxController;

if (!defined('ABSPATH')) {
    exit;
}


// If checkout registration is disabled and not logged in, the user cannot checkout.
if (!$checkout->is_registration_enabled() && $checkout->is_registration_required() && !is_user_logged_in()) {
    echo esc_html(apply_filters('woocommerce_checkout_must_be_logged_in_message', __('You must be logged in to checkout.', 'woocommerce')));
    return;
}
?>
<!--Custom styling: color,...-->
<?php
if (class_exists('\RTLPlugins\AstarehCore\Controllers\MetaboxController')):
    $page_background_color = MetaboxController::getMetaValue('metaboxes-page-color', true, '', get_the_ID());
    ?>
    <style>
        body {
            background-color: <?php echo esc_html($page_background_color); ?> !important;
        }
    </style>
<?php
endif;
?>
<div class="container mb-5 ">
    <div class="rc-woo-user-title-panel p-3 rounded-3 bg-primary-600 d-flex align-items-center my-5">
        <div class="rc-title-single-portfolio">
            <p class="color-secondary-600 text-xx1">
                <?php echo __('Checkout', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
            </p>
        </div>
    </div>

    <div class="rc-woo-user-panel-content">
        <?php do_action('woocommerce_before_checkout_form', $checkout); ?>
        <div class="rc-woo-checkout-billing-details">
            <div class="woocommerce-checkout-form rounded-4 p-4 d-flex flex-column ">
                <form name="checkout" method="post" class="checkout woocommerce-checkout"
                      action="<?php echo esc_url(wc_get_checkout_url()); ?>"
                      enctype="multipart/form-data"
                >
                    <input type="hidden" name="privacy_policy" value="true"/>


                    <?php if ($checkout->get_checkout_fields()) : ?>

                        <?php do_action('woocommerce_checkout_before_customer_details'); ?>

                        <div class="col2-set" id="customer_details">
                            <div class="col-1">
                                <?php do_action('woocommerce_checkout_billing'); ?>
                            </div>

                            <div class="col-2">
                                <?php do_action('woocommerce_checkout_shipping'); ?>
                            </div>
                        </div>

                        <?php do_action('woocommerce_checkout_after_customer_details'); ?>

                    <?php endif; ?>

                    <?php do_action('woocommerce_checkout_before_order_review_heading'); ?>

                    <h3 id="order_review_heading"><?php esc_html_e('Your order', 'woocommerce'); ?></h3>

                    <?php do_action('woocommerce_checkout_before_order_review'); ?>

                    <div id="order_review" class="woocommerce-checkout-review-order">
                        <?php do_action('woocommerce_checkout_order_review'); ?>
                    </div>

                    <?php do_action('woocommerce_checkout_after_order_review'); ?>

                </form>

                <?php do_action('woocommerce_after_checkout_form', $checkout); ?>
            </div>
        </div>
    </div>
</div>