<?php

/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 10.1.0
 */

use RTLPlugins\AstarehCore\Controllers\MetaboxController;
use RTLPlugins\AstarehCore\Controllers\OptionController;

defined('ABSPATH') || exit;
if (function_exists('astareh_breadcrumb')) {
    astareh_breadcrumb();
}
?>
<!--Custom styling: color,...-->
<?php
if (class_exists('\RTLPlugins\AstarehCore\Controllers\MetaboxController')):
    $page_background_color = MetaboxController::getMetaValue('metaboxes-page-color', true, '', get_the_ID());

    ?>
    <style>
        body {
            background-color: <?php echo esc_html($page_background_color); ?> !important;
        }
    </style>
<?php
endif;
?>
<div class="rc-sec-woo-user-panel pb-5">
    <div class="container">
        <?php do_action('woocommerce_before_cart'); ?>

        <div class="rc-woo-user-title-panel p-3 rounded-3 bg-primary-600 d-flex align-items-center my-5">
            <div class="rc-title-single-portfolio">
                <p class="color-secondary-600 text-xx1">
                    <?php echo __('Shopping Cart', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                </p>
            </div>
        </div>


        <form class="woocommerce-cart-form bg-primary-450 rounded-4" action="<?php echo esc_url(wc_get_cart_url()); ?>" method="post">
            <?php do_action('woocommerce_before_cart_table'); ?>

            <ul class="shop_table shop_table_responsive cart woocommerce-cart-form__contents" cellspacing="0">

                <?php do_action('woocommerce_before_cart_contents'); ?>

                <?php
                foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
                    $_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
                    $product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);
                    /**
                     * Filter the product name.
                     *
                     * @since 2.1.0
                     * @param string $product_name Name of the product in the cart.
                     * @param array $cart_item The product in the cart.
                     * @param string $cart_item_key Key for the product in the cart.
                     */
                    $product_name = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );

                    if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_cart_item_visible', true, $cart_item, $cart_item_key)) {
                        $product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
                        ?>
                        <li class="w-100 rc-woo-cart-shop-item p-4 bg-primary-500 rounded-4 mb-4 d-flex align-items-center woocommerce-cart-form__cart-item <?php echo esc_attr(apply_filters('woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key)); ?>">
                            <div
                                class="rc-woo-cart-shop-item-flex-control d-flex flex-column flex-md-row flex-lg-column flex-xl-row align-items-center w-100">
                                <div
                                    class="rc-woo-cart-shop-item-right d-flex flex-column flex-lg-row align-items-center w-100 w-lg-100 w-xl-35 gap-3 pe-md-2 pb-4 pb-md-0 position-relative">
                                    <div
                                        class="rc-woo-cart-shop-item-img rc-woo-cart-shop-item-inner position-relative rounded-3 overflow-hidden">
                                        <div class="rc-woo-cart-shop-item-img-filter"></div>
                                        <?php
                                        $thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);

                                        if (!$product_permalink) {
                                            echo $thumbnail; // PHPCS: XSS ok.
                                        } else {
                                            printf('<a href="%s">%s</a>', esc_url($product_permalink), $thumbnail); // PHPCS: XSS ok.
                                        }
                                        ?>
                                    </div>
                                    <div
                                        class="rc-woo-cart-shop-item-title rc-woo-cart-shop-item-inner d-flex flex-column position-relative align-items-center align-items-lg-start">
                                        <div class="rc-woo-cart-shop-item-title-product">
                                            <?php
                                            if (!$product_permalink) {
                                                /**
                                                 * This filter is documented above.
                                                 *
                                                 * @since 2.1.0
                                                 */
                                                echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key ) );
                                            } else {
                                                /**
                                                 * Filter the product name.
                                                 *
                                                 * @param string $product_url URL the product in the cart.
                                                 * @since 7.8.0
                                                 */
                                                echo wp_kses_post(apply_filters('woocommerce_cart_item_name', sprintf('<a href="%s">%s</a>', esc_url($product_permalink), $product_name), $cart_item, $cart_item_key));
                                            }

                                            do_action('woocommerce_after_cart_item_name', $cart_item, $cart_item_key);

                                            // Meta data.
                                            echo wc_get_formatted_cart_item_data($cart_item); // PHPCS: XSS ok.

                                            // Backorder notification.
                                            if ($_product->backorders_require_notification() && $_product->is_on_backorder($cart_item['quantity'])) {
                                                echo wp_kses_post(apply_filters('woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__('Available on backorder', 'woocommerce') . '</p>', $product_id));
                                            }
                                            ?>
                                        </div>
                                        <div
                                            class="rc-woo-user-panel-downloads-item-category rc-woo-user-panel-downloads-item-inner d-flex position-relative justify-content-center justify-content-md-start align-items-center flex-wrap"
                                        >
                                            <span class="text-lg-sm text-xs-xs color-primary-200">
                                                <?php echo __( "Category:", _get_theme_constant( 'THEME_TEXTDOMAIN' ) ) ?>
                                                        </span>
                                                    
                                                        <?php
														try {
															$separator = OptionController::getOptionValue( 'general-options-category-separator-ltr' );
															if ( is_rtl() ) {
																$separator = OptionController::getOptionValue( 'general-options-category-separator-rtl' );
															}
														} catch (Throwable $e) {
															$separator = ',';
															error_log( $e->getMessage(), E_ERROR );
														}
														$product_categories = get_the_terms( $product_id, 'product_cat' );
														if ( is_wp_error( $product_categories ) ) {
															$product_categories = [];
														}
                                                        if ( ! empty( $product_categories ) ) : ?>
                                                            <?php
                                                            $count_categories = count( $product_categories );

                                                            ?>
                                                            <?php foreach ( $product_categories as $category_index => $category ) : ?>
                                                    
                                                                <a href="<?php echo esc_url( get_term_link( $category, 'product_cat' ) ) ?>"
                                                                    class="ms-1 text-lg-sm text-xs-xs  pe-1 color-primary-200">
                                                                    <?php echo esc_html( $category->name ); ?>
                                                                    <?php if ( $category_index < $count_categories - 1 && $count_categories > 1 ) {
                                                                        echo esc_html( $separator );
                                                                    } ?>
                                                    
                                                                </a>
                                                            <?php endforeach; ?>
                                                        <?php endif; ?>
                                                    </div>

                                                </div>
                                            </div>


                                <div
                                    class="rc-woo-cart-shop-item-left d-flex flex-column flex-lg-row align-items-center w-100 w-lg-100 w-xl-65 gap-md-1 gap-lg-4 ps-xl-3 p-0 pt-md-0 mt-lg-3 mt-xl-0">
                                    <div
                                        class="rc-woo-cart-shop-item-price-cnt rc-woo-cart-shop-item-inner d-flex flex-column flex-md-row flex-lg-column align-items-center align-items-lg-start gap-3 justify-content-center justify-content-center position-relative pe-lg-5 w-lg-25">
                                        <span class="text-sm purchase-amount">
                                            <?php esc_html_e('Price', 'woocommerce'); ?>
                                        </span>
                                        <div class="rc-woo-cart-shop-item-purchase-cnt d-flex mt-2 pb-4 pb-md-0">
                                            <span class="text-sm text-xl-lg">
                                                <?php
                                                echo apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key); // PHPCS: XSS ok.
                                                ?>
                                            </span>
                                        </div>
                                    </div>
                                    <div
                                        class="rc-woo-cart-shop-item-number-products rc-woo-cart-shop-item-inner d-flex flex-column flex-md-row flex-lg-column align-items-center align-items-lg-start gap-3 justify-content-md-center position-relative pe-md-4 py-4 py-md-0 pb-md-0 w-lg-25">
                                        <span class="text-sm download-date">
                                            <?php esc_html_e('Quantity', 'woocommerce'); ?>
                                        </span>
                                        <div
                                            class="rc-woo-cart-shop-item-number-products-cnt  d-flex flex-column justify-content-center d-flex mt-2">
                                            <span class="text-sm text-xl-lg">
                                                <?php
                                                if ($_product->is_sold_individually()) {
                                                    $min_quantity = 1;
                                                    $max_quantity = 1;
                                                } else {
                                                    $min_quantity = 0;
                                                    $max_quantity = $_product->get_max_purchase_quantity();
                                                }

                                                $product_quantity = woocommerce_quantity_input(
                                                    [
                                                        'input_name' => "cart[{$cart_item_key}][qty]",
                                                        'input_value' => $cart_item['quantity'],
                                                        'max_value' => $max_quantity,
                                                        'min_value' => $min_quantity,
                                                        'product_name' => $product_name,
                                                    ],
                                                    $_product,
                                                    false
                                                );

                                                echo apply_filters('woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item); // PHPCS: XSS ok.
                                                ?>
                                            </span>
                                        </div>
                                    </div>
                                    <div
                                        class="rc-woo-cart-shop-item-number-products rc-woo-cart-shop-item-inner d-flex flex-column flex-md-row flex-lg-column align-items-center align-items-lg-start gap-3 justify-content-center justify-content-center position-relative pe-md-4 py-4 py-md-0 pb-md-0 w-lg-30">
                                        <span class="text-sm download-date">
                                            <?php esc_html_e('Subtotal', 'woocommerce'); ?>
                                        </span>
                                        <div
                                            class="rc-woo-cart-shop-item-number-products-cnt  d-flex flex-column justify-content-center d-flex mt-2">
                                            <span class="text-sm text-xl-lg">
                                                <?php
                                                echo apply_filters('woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal($_product, $cart_item['quantity']), $cart_item, $cart_item_key); // PHPCS: XSS ok.
                                                ?>
                                            </span>
                                        </div>
                                    </div>
                                    <div
                                        class="rc-woo-cart-shop-item-links rc-woo-cart-shop-item-inner position-relative d-flex flex-column justify-content-center ms-lg-auto py-4">
                                        <div class="rc-woo-cart-shop-item-links-cnt d-flex">
                                            <div class="rc-woo-cart-shop-product-dl">
                                                <?php
                                                echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                                    'woocommerce_cart_item_remove_link',
                                                    sprintf(
                                                        '<a href="%s" class="px-5 py-3 rounded-3" aria-label="%s" data-product_id="%s" data-product_sku="%s">%s</a>',
                                                        esc_url(wc_get_cart_remove_url($cart_item_key)),
                                                        /* translators: %s is the product name */
                                                        esc_attr( sprintf( __( 'Remove %s from cart', 'woocommerce' ), wp_strip_all_tags( $product_name ) ) ),
                                                        esc_attr($product_id),
                                                        esc_attr($_product->get_sku()),
                                                        __('Delete', _get_theme_constant('THEME_TEXTDOMAIN'))
                                                    ),
                                                    $cart_item_key
                                                );
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </li>

                        <?php
                    }
                }
                ?>
            </ul>
            <?php do_action('woocommerce_cart_contents'); ?>

            <div class="rc-woo-dw-product-list-items-cnt mt-4">
                <div class="justify-content-around align-items-center align-items-lg-start mb-5 pb-5 d-flex flex-column flex-lg-row g-5 g-lg-0">
                    <div class="coupon-section col-lg-6 col-11 bg-primary-500 p-4  rounded-4">
                        <?php if (wc_coupons_enabled()) { ?>
                            <div class="rc-woo-discount-code d-flex">
                                <div class="coupon rc-woo-discount-code-input-cnt d-flex flex-md-row w-100">
                                    <label for="coupon_code"
                                           class="screen-reader-text"
                                    >
                                        <?php esc_html_e('Coupon:', 'woocommerce'); ?></label>
                                    <div class="rc-woo-discount-code-input d-flex rounded-3 overflow-hidden w-100">
                                        <input type="text" name="coupon_code" class="input-text w-100" id="coupon_code"
                                               value=""
                                               placeholder="<?php esc_attr_e('Coupon code', 'woocommerce'); ?>"
                                        />
                                    </div>
                                    <button type="submit"
                                            class="rc-woo-discount-code-submit-btn bg-primary-300 text-nowrap ms-4 px-5 rounded-3 text-white <?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"
                                            name="apply_coupon"
                                            value="<?php esc_attr_e('Apply coupon', 'woocommerce'); ?>"
                                    >
                                        <?php esc_html_e('Apply coupon', 'woocommerce'); ?>
                                    </button>

                                    <?php do_action('woocommerce_cart_coupon'); ?>
                                </div>
                            </div>
                        <?php } ?>
                        <div class="row">
                            <div class="col-12 p-4 bg-primary-500 rounded-4 d-flex w-100 justify-content-end">
                                <button type="submit"
                                        class="bg-primary-300 color-primary-100 p-3 rounded-4 <?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"
                                        name="update_cart"
                                        value="<?php esc_attr_e('Update cart', 'woocommerce'); ?>"><?php esc_html_e('Update cart', 'woocommerce'); ?></button>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 col-11 bg-primary-500 p-4  rounded-4 mt-2 mt-lg-0">
                        <?php do_action('woocommerce_before_cart_collaterals'); ?>

                        <div class="cart-collaterals">
                            <?php
                            /**
                             * Cart collaterals hook.
                             *
                             * @hooked woocommerce_cross_sell_display
                             * @hooked woocommerce_cart_totals - 10
                             */
                            do_action('woocommerce_cart_collaterals');
                            ?>
                        </div>
                    </div>
                </div>
            </div>


            <?php do_action('woocommerce_cart_actions'); ?>

            <?php wp_nonce_field('woocommerce-cart', 'woocommerce-cart-nonce'); ?>


            <?php do_action('woocommerce_after_cart_contents'); ?>




            <?php do_action('woocommerce_after_cart_table'); ?>
        </form>


        <?php do_action('woocommerce_after_cart'); ?>
    </div>
</div>