<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

defined('ABSPATH') || exit;

use RTLPlugins\AstarehCore\Controllers\MetaboxController;
use RTLPlugins\AstarehCore\Controllers\OptionController;

get_header('shop');

if (function_exists('astareh_breadcrumb')) {
    astareh_breadcrumb();
}

remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);

wp_enqueue_script(__THEME_PREFIX . 'masonry');
/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );

try {
    $custom_title = OptionController::getOptionValue('shop-archive-custom-title', '');
    $sidebar_layout = OptionController::getOptionValue('shop-archive-layout', 'none');
    $responsive_sidebar_layout = OptionController::getOptionValue('shop-archive-sidebar-responsive-layout', 'none');
    $enable_search = OptionController::getOptionValue('shop-archive-search', false);
    $enable_filters = OptionController::getOptionValue('shop-archive-filters', false);
    $enable_categories = OptionController::getOptionValue('shop-archive-categories', false);
    $enable_popular_categories = OptionController::getOptionValue('shop-archive-popular-categories', false);
    $category_count = OptionController::getOptionValue('shop-archive-category-count', 10);

} catch (Throwable $e) {
    $custom_title = '';
    $sidebar_layout = 'none';
    $responsive_sidebar_layout = 'none';
    $enable_search = false;
    $enable_filters = false;
    $enable_categories = false;
    $category_count = 10;
    $enable_popular_categories = false;
    error_log($e->getMessage(), E_ERROR);
}
/**
 * All parent categories of the shop
 */
$args = [
    'taxonomy' => 'product_cat',
    'hide_empty' => true,
    'parent' => 0,
    'number' => $category_count,
];

$categories = get_terms($args);

/**
 * Popular best sell categories
 */
if (function_exists('astareh_list_best_selling_woocommerce_categories')
    && $enable_popular_categories
) {
    $popular_categories = astareh_list_best_selling_woocommerce_categories($category_count);
}


?>
    <!--Custom styling: color,...-->
<?php
if (class_exists('\RTLPlugins\AstarehCore\Controllers\MetaboxController')):
    $woocommerce_shop_page_id = get_option('woocommerce_shop_page_id');
    $page_background_color = MetaboxController::getMetaValue('metaboxes-page-color', true, '', $woocommerce_shop_page_id);
    ?>
    <style>
        body.post-type-archive-product {
            background-color: <?php echo esc_html($page_background_color); ?> !important;
        }
    </style>
<?php
endif;
?>


    <section class="rc-product-archive mb-5 mt-5">

        <div>
            <?php
            if (woocommerce_product_loop()) {
                /**
                 * Hook: woocommerce_before_shop_loop.
                 *
                 * @hooked woocommerce_output_all_notices - 10
                 * @hooked woocommerce_result_count - 20 // DISABLED
                 * @hooked woocommerce_catalog_ordering - 30 // removed and customized
                 */
                do_action('woocommerce_before_shop_loop');
            }
            ?>
        </div>

        <div class="container ">
            <div class="rc-page-cnt ">

                <!--Shop Heading-->
                <header class="rc-product-archive-top d-flex">
                    <div class="rc-product-archive-title w-100 p-3 bg-primary-600 rounded-3">
                        <?php if (!empty($custom_title)): ?>
                            <h1 class="color-secondary-600 text-xx1 woocommerce-products-header__title page-title">
                                <?php echo esc_html__($custom_title, _get_theme_constant('THEME_TEXTDOMAIN')) ?>
                            </h1>
                        <?php else: ?>
                            <?php if (apply_filters('woocommerce_show_page_title', true)) : ?>
                                <h1 class="color-secondary-600 text-xx1 woocommerce-products-header__title page-title">
                                    <?php woocommerce_page_title(); ?>
                                </h1>
                            <?php endif; ?>
                        <?php endif; ?>

                    </div>
                    <?php
                    /**
                     * Hook: woocommerce_archive_description.
                     *
                     * @hooked woocommerce_taxonomy_archive_description - 10
                     * @hooked woocommerce_product_archive_description - 10
                     */
                    do_action('woocommerce_archive_description');
                    ?>
                </header>


                <div class="rc-product-archive-dw d-flex flex-column flex-md-row mt-4">

                    <?php if ($sidebar_layout != 'none'): ?>

                        <?php
                        // Prepare Custom Classes based on layout
                        if ($sidebar_layout == 'right') {
                            $sidebar_custom_class = ' order-md-1 me-md-4 ';
                        } else {
                            $sidebar_custom_class = ' order-md-2 ms-md-4 ';
                        }

                        if ($responsive_sidebar_layout == 'top') {
                            $sidebar_custom_class .= ' order-1 ';
                        } elseif ($responsive_sidebar_layout == 'bottom') {
                            $sidebar_custom_class .= ' order-2 ';
                        } else {
                            $sidebar_custom_class .= ' ';
                        }
                        ?>
                        <!--SEARCH AND SIDEBAR-->
                        <section class="rc-product-archive-sidebar <?php echo esc_attr($sidebar_custom_class) ?>">
                            <div class="rc-product-archive-sidebar-cnt d-flex flex-column">
                                <?php if ($enable_search): ?>
                                    <form
                                        class="rc-search-box-product-sidebar rc-border-blue rounded-4 p-2 bg-primary-600"
                                        action="<?php echo esc_url(home_url('/')) ?>"
                                    >


                                        <div class="rc-search-box d-flex">
                                            <div
                                                class="rc-search-box-product-sidebar-input d-flex w-100 rounded-3 overflow-hidden"
                                            >
                                                <input name="post_type"
                                                       type="hidden"
                                                       value="product"
                                                       id="post_type"
                                                />
                                                <input name="s"
                                                       value="<?php the_search_query(); ?>"
                                                       type="text"
                                                       class="w-100 ps-3"
                                                       placeholder="<?php echo __(
                                                           'Search',
                                                           _get_theme_constant('THEME_TEXTDOMAIN')
                                                       ) ?>"
                                                />
                                            </div>

                                            <button type="submit"
                                                    class="rc-search-box-product-sidebar-btn-search d-flex flex-column justify-content-center align-items-center bg-secondary-600 rounded-3 ms-2"
                                            >
                                                <div
                                                    class="rc-search-box-product-sidebar-icon-search d-flex flex-column justify-content-center align-items-center"
                                                >
                                                    <span
                                                        class="iconsax-outline-search-normal-1 text-md text-white"></span>
                                                </div>
                                            </button>
                                        </div>
                                    </form>
                                <?php endif; ?>


                                <?php
                                if ($enable_filters) {
                                    /**
                                     * Astareh custom woocommerce place to show order filter
                                     */
                                    do_action('astareh/theme/woocommerce_show_order_filter');
                                }
                                ?>

                                <!--CATEGORIES-->
                                <?php if ($enable_categories): ?>
                                    <div
                                        class="rc-product-category-sidebar rc-border-blue rounded-4 p-2 bg-primary-600 d-flex flex-column mt-3"
                                    >
                                        <div
                                            class="rc-product-category-sidebar-title d-flex flex-column justify-content-center align-items-center rounded-3 p-3"
                                        >
                                            <p class="color-secondary-600 text-md">
                                                <?php echo __('Categories', _get_theme_constant('THEME_TEXTDOMAIN')) ?>
                                            </p>
                                        </div>
                                        <div class="rc-product-categories d-flex mt-4">
                                            <ul class="d-flex flex-column w-100 px-2">

                                                <?php if (!empty($categories) && !is_wp_error($categories)): ?>
                                                    <?php foreach ($categories as $category) : ?>
                                                        <li class="d-flex w-100 align-items-center">
                                                            <div class="rc-link">
                                                                <a class="text-white position-relative d-flex align-items-center ps-3"
                                                                   href="<?php echo get_term_link($category); ?>"
                                                                >
                                                                    <?php echo esc_html($category->name); ?>
                                                                </a>
                                                            </div>
                                                            <div
                                                                class="count ms-auto bg-secondary-600 px-2 py-1 rounded-3">
                                                                <span class="color-primary-400">
                                                                    <?php echo esc_html($category->count) ?>
                                                                </span>
                                                            </div>
                                                        </li>
                                                    <?php endforeach; ?>
                                                <?php else: ?>
                                                    <p>
                                                        <?php echo __('This shop doesn\'t contains any category.', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                                                    </p>
                                                <?php endif; ?>

                                            </ul>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <!--POPULAR CATEGORIES-->
                                <?php if ($enable_popular_categories): ?>
                                    <div
                                        class="rc-product-category-sidebar rc-border-blue rounded-4 p-2 bg-primary-600 d-flex flex-column mt-3"
                                    >
                                        <div
                                            class="rc-product-category-sidebar-title d-flex flex-column justify-content-center align-items-center rounded-3"
                                        >
                                            <p class="color-secondary-600 text-md">
                                                <?php echo __('Populars', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                                            </p>
                                        </div>
                                        <div class="rc-product-categories d-flex mt-4">
                                            <ul class="d-flex flex-column w-100 px-2">

                                                <?php if (!empty($popular_categories)): ?>
                                                    <?php foreach ($popular_categories as $popular_category) : ?>
                                                        <li class="d-flex w-100 align-items-center">
                                                            <div class="rc-link">
                                                                <a class="text-white position-relative d-flex align-items-center ps-3"
                                                                   href="<?php echo esc_url($popular_category['link']); ?>"
                                                                >
                                                                    <?php echo esc_html($popular_category['name']) ?>
                                                                </a>
                                                            </div>
                                                            <div
                                                                class="count ms-auto bg-secondary-600 px-2 py-1 rounded-3">
                                                                <span class="color-primary-400">
                                                                    <?php echo esc_html($popular_category['count']) ?>
                                                                </span>
                                                            </div>
                                                        </li>
                                                    <?php endforeach; ?>
                                                <?php else: ?>
                                                    <p>
                                                        <?php echo __('This shop doesn\'t contains any popular category.', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
                                                    </p>
                                                <?php endif; ?>


                                            </ul>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </section>
                    <?php endif; ?>

                    <!--PRODUCTS-->
                    <?php
                    $content_custom_class = '  ';

                    if ($sidebar_layout == 'right') {
                        $content_custom_class = ' order-md-2 ';
                    }
                    if ($sidebar_layout == 'left') {
                        $content_custom_class = ' order-md-1 ';
                    }

                    if ($responsive_sidebar_layout == 'top') {
                        $content_custom_class .= ' order-2 ';
                    } else {
                        $content_custom_class .= ' order-1 ';
                    }

                    /*Configure masonry js*/
                    $masonry_configuration = '{"percentPosition": true';
                    if (is_rtl()) {
                        $masonry_configuration .= ', "originLeft" : false';
                    }
                    $masonry_configuration .= '}';

                    ?>
                    <section class="rc-product-archive mt-4 mt-md-0 <?php echo esc_attr($content_custom_class) ?>">
                        <div class="rc-product-items-cnt d-flex flex-column">
                            <div class="rc-product-archive-items">


                                <div class="row gy-4"
                                     data-masonry='<?php echo $masonry_configuration; ?>'
                                >
                                    <?php
                                    if (woocommerce_product_loop()) {
                                        /**
                                         * Hook: woocommerce_before_shop_loop.
                                         *
                                         * @hooked woocommerce_output_all_notices - 10
                                         * @hooked woocommerce_result_count - 20 // DISABLED
                                         * @hooked woocommerce_catalog_ordering - 30 // removed and customized
                                         */
                                        /**
                                         * RTL : moved to top
                                         */
                                        /*do_action('woocommerce_before_shop_loop');*/

                                        woocommerce_product_loop_start();

                                        if (wc_get_loop_prop('total')) {
                                            while (have_posts()) {
                                                the_post();

                                                /**
                                                 * Hook: woocommerce_shop_loop.
                                                 */
                                                do_action('woocommerce_shop_loop');

                                                wc_get_template_part('content', 'product');
                                            }
                                        }

                                        woocommerce_product_loop_end();

                                        /**
                                         * Hook: woocommerce_after_shop_loop.
                                         *
                                         * @hooked woocommerce_pagination - 10
                                         */
                                        ?>
                                        <div class="rc-woo-pagination pb-5 mb-5 pt-5 mt-5">
                                            <?php
                                            do_action('woocommerce_after_shop_loop');
                                            ?>
                                        </div>
                                        <?php
                                    } else {
                                        /**
                                         * Hook: woocommerce_no_products_found.
                                         *
                                         * @hooked wc_no_products_found - 10
                                         */
                                        do_action('woocommerce_no_products_found');
                                    }

                                    /**
                                     * Hook: woocommerce_after_main_content.
                                     *
                                     * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
                                     */
                                    do_action('woocommerce_after_main_content');

                                    /**
                                     * Hook: woocommerce_sidebar.
                                     *
                                     * @hooked woocommerce_get_sidebar - 10
                                     */
                                    do_action('woocommerce_sidebar');

                                    ?>
                                </div>
                            </div>
                        </div>
                    </section>


                </div>


            </div>
        </div>
    </section>
<?php

get_footer('shop');
