<?php
/**
 * The template for displaying singular post-types: posts, pages and user-defined custom post types.
 *
 * @package ResumeChi
 */

use RTLPlugins\AstarehCore\Controllers\MetaboxController;
use RTLPlugins\AstarehCore\Controllers\OptionController;
use RTLPlugins\AstarehCore\Controllers\PostTypeController;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/*HEADING ICONS*/
$date_icon = get_template_directory_uri() . '/assets/images/date.svg';
$comments_icon = get_template_directory_uri() . '/assets/images/comments.svg';
$view_icon = get_template_directory_uri() . '/assets/images/view-icon.svg';
$author_icon = get_template_directory_uri() . '/assets/images/author.svg';
$share_icon = get_template_directory_uri() . '/assets/images/icon-share.svg';
$calendar_icon = get_template_directory_uri() . '/assets/images/calendar-small-icon.svg';
$like_icon = get_template_directory_uri() . '/assets/images/like.svg';
while ( have_posts() ) :
	the_post();

	if ( function_exists( 'astareh_breadcrumb' ) ) {
		astareh_breadcrumb();
	}


	$user_ip = isset( $_SERVER['REMOTE_ADDR'] ) ? $_SERVER['REMOTE_ADDR'] : 'UNKNOWN';
	$key = $user_ip . '__' . get_the_ID();
	$value = [ $user_ip, get_the_ID() ];
	$visited = get_transient( $key );
	if ( empty( $visited ) ) {
		set_transient( $key, $value, 60 * 60 * 12 );
		$count_key = 'astareh_views';
		$count = get_post_meta( get_the_ID(), $count_key, true );
		if ( $count == '' ) {
			$count = 0;
			delete_post_meta( get_the_ID(), $count_key );
			add_post_meta( get_the_ID(), $count_key, $count );
		} else {
			$count++;
			update_post_meta( get_the_ID(), $count_key, $count );
		}
	}

	$count_key = 'astareh_views';
	$count = get_post_meta( get_the_ID(), $count_key, true );
	if ( $count == '' ) {
		delete_post_meta( get_the_ID(), $count_key );
		add_post_meta( get_the_ID(), $count_key, '0' );
		$count = '0';
	}

	$view_count = $count;

	/*COUNT THE APPROVED COMMENTS*/
	$comment_count = get_comment_count( get_the_ID() )['approved'];

	/*GET THE POST AUTHOR*/
	$author = get_the_author_meta( 'nickname' );


	$publish_date = the_date( 'Y/m/d', '', '', false );
	if ( is_rtl() && function_exists( 'jdate' ) ) {
		$time_stamp = strtotime( $publish_date );
		$publish_date = jdate( $publish_date )->format( 'Y/m/d' );
	}
	/*CATEGORIES*/
	$categories = wp_get_post_categories( get_the_ID(), [ 
		'hide_empty' => 'true',
		'fields' => 'names'
	] );
	$categories_count = count( $categories );
	$category_separator = ( is_rtl() )
		? OptionController::getOptionValue( 'general-options-category-separator-rtl', '،' )
		: OptionController::getOptionValue( 'general-options-category-separator-ltr', ',' );
	$category_last_item = $categories_count - 1;
	$category_links = '';
	/*
	 * There is two ways to show category archive:
	 * 1. via archive permalink
	 * 2. via category archive permalink
	 */
	$enable_main_archive = OptionController::getOptionValue( 'post-single-category-link' );
	$category_link = get_post_type_archive_link( 'post' );
	if ( ! empty( $categories ) ) {
		foreach ( $categories as $index => $category ) {
			if ( ! $enable_main_archive ) {
				$category_id = get_cat_ID( $category );
				$category_link = get_category_link( $category_id );
			}
			$category_links .= sprintf(
				"<a class='%1s' href='%2s'> %3s </a>%4s",
				'blog-category-link',
				esc_url( $category_link ),
				$category,
				( $index != $category_last_item ) ? $category_separator : ''
			);
		}
	}


	/*TAGS*/
	$tags = get_the_tags( get_the_ID() );

	/*RECENT POSTS*/
	$enable_recent_posts = OptionController::getOptionValue( 'post-single-show-latest-articles' );
	$recent_posts = wp_get_recent_posts( [ 
		'numberposts' => 4,
		'post_status' => 'publish',
		'exclude' => get_the_ID()
	] );


	/*RECENT POSTS*/
	$enable_comments = OptionController::getOptionValue( 'post-single-enable-comments' )
		?>

	<!--Custom styling: color,...-->
	<?php
	$page_background_color = MetaboxController::getMetaValue( 'metaboxes-page-color', true, '', get_the_ID() );
	?>
	<style>
		body {
			background-color:
				<?php echo esc_html( $page_background_color ); ?>
				!important;
		}
	</style>

	<!--TODO : FIND A BETTER WAY ABOUT ENQUEUING STYLE OF EACH PAGE-->
	<!--Custom page font loading-->

	<?php
	if ( ! empty( OptionController::getOptionValue( 'post-single-font' ) ) ) :
		$page_font_string = implode( ',', OptionController::getOptionValue( 'post-single-font' ) );
		?>
		<style>
			.rc-sec-single-blog {
				font-family:
					<?php echo esc_html( $page_font_string ); ?>
				;
			}
		</style>
		<?php
	endif;
	?>
	<!--END STYLES-->


	<section class="rc-sec-single-blog">
		<div class="container">

			<!--HEADING-->
			<div
				class="title-box-1 p-3 rounded-3 bg-primary-600 d-flex flex-column flex-lg-row align-items-lg-center my-5 mb-4">
				<div class="title">
					<h1 class="color-secondary-600 entry-title text-lg">
						<?php the_title() ?>
					</h1>
				</div>
				<div class="left ms-lg-auto d-flex flex-column flex-lg-row align-items-lg-center">
					<div class="date item-left d-flex ps-lg-3 py-2">
						<div class="item-left-icon me-2">
							<img class="w-100" src="<?php echo esc_url( $date_icon ) ?>" alt="">
						</div>
						<span class="color-primary-200">
							<?php echo esc_html( $publish_date ); ?>

						</span>
					</div>
					<div class="comments item-left d-flex ps-lg-3 ms-lg-4 py-2">
						<div class="item-left-icon me-2">
							<img class="w-100" src="<?php echo esc_url( $comments_icon ); ?>" alt="">
						</div>
						<a href="#comments">
							<?php
							printf(
								__( '%1s Comments', _get_theme_constant( 'THEME_TEXTDOMAIN' ) ),
								$comment_count
							);
							?>
						</a>
					</div>
					<div class="view item-left d-flex ps-lg-3 ms-lg-4 py-2">
						<div class="item-left-icon me-2">
							<img class="w-100" src="<?php echo esc_url( $view_icon ) ?>" alt="">
						</div>
						<span class="color-primary-200">
							<?php
							printf(
								__( '%1s Views', _get_theme_constant( 'THEME_TEXTDOMAIN' ) ),
								$view_count
							);
							?>
						</span>
					</div>
					<div class="author item-left mx-lg-4 d-flex ps-lg-3 py-2">
						<div class="item-left-icon me-2">
							<img class="w-100" src="<?php echo esc_url( $author_icon ) ?>" alt="">
						</div>
						<span class="color-primary-200">
							<?php echo esc_html( $author ) ?>
						</span>
					</div>
					<?php get_template_part( 'template-parts/share-box' ) ?>
				</div>
			</div>


			<!--THE CONTENT-->
			<?php $image = get_the_post_thumbnail( get_the_ID(), 'full', [ 'class' => 'w-100 rounded-4' ] ); ?>
			<div class="rc-single-blog-post-blog p-lg-5 p-3 rounded-4 d-flex flex-column">
				<?php if ( ! empty( $image ) ) : ?>
					<div class="rc-single-blog-post-blog-img-cnt position-relative">
						<div class="rc-single-blog-post-blog-img-border-back"></div>
						<div class="position-relative">
							<div class="rc-single-blog-post-blog-img w-100">
								<?php echo $image ?>

							</div>
						</div>
					</div>
				<?php endif; ?>

				<div class="post-content">
					<div class="rc-single-blog-sec-1 my-5">
						<div class="line-h-normal">
							<?php the_content(); ?>
						</div>
					</div>

				</div>


				<!--CATEGORIES-->
				<div class="rc-single-blog-category d-flex mt-5 position-relative pb-4">
					<span class="me-2">
						<?php echo __( 'Categories', _get_theme_constant( 'THEME_TEXTDOMAIN' ) ) . ':' ?>
					</span>
					<span>
						<?php echo $category_links ?>
					</span>
				</div>
				<?php if ( ! empty( $tags ) ) : ?>
					<div class="rc-single-blog-tags d-flex align-items-center mt-3 flex-column flex-md-row ">
						<span class="me-2 mb-3 mb-md-0">
							<?php echo __( 'Tags', _get_theme_constant( 'THEME_TEXTDOMAIN' ) ) . ':' ?>
						</span>
						<div class="tags-item-cnt d-flex flex-wrap">
							<?php foreach ( $tags as $tag ) :
								?>
								<div class="rc-single-blog-tags-item px-3 py-2 rounded-3 me-3 mb-3 mb-md-0">
									<a href="<?php echo esc_url( get_tag_link( $tag ) ) ?>">
										<?php echo esc_html__( $tag->name, _get_theme_constant( 'THEME_TEXTDOMAIN' ) ) ?>
									</a>
								</div>
							<?php endforeach; ?>

						</div>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</section>


	<?php if ( $enable_recent_posts && ! empty( $recent_posts ) ) : ?>
		<!--LATEST ARTICLES-->
		<section class="rc-single-blog-post-blog-other-posts d-flex flex-column mt-5 p-lg-5 p-3 pb-5 bg-primary-600 rounded-3">
			<div class="container">
				<div class="rc-single-blog-post-blog-title-section d-flex mb-4 bg-primary-500 p-3 rounded-3 align-items-center">
					<div class="rc-single-blog-post-blog-right">
						<p class="color-secondary-500">
							<?php echo __( 'Latest Articles', _get_theme_constant( 'THEME_TEXTDOMAIN' ) ); ?>
						</p>
					</div>
					<div class="left ms-auto">
						<div class="rc-single-blog-post-blog-btn-more-posts">
							<a class="color-primary-500" href="<?php echo get_post_type_archive_link( 'post' ); ?>">
								<?php echo __( 'More Items...', _get_theme_constant( 'THEME_TEXTDOMAIN' ) ) ?>
							</a>
						</div>
					</div>
				</div>
				<div class="blog-post-box-cnt w-100">
					<div class="row gy-4 justify-content-between">
						<?php foreach ( $recent_posts as $recent_post ) : ?>
							<?php
							$recent_post_thumbnail = esc_url( get_the_post_thumbnail_url( $recent_post['ID'], 'medium' ) );
							$recent_post_title = esc_html( mb_strimwidth( $recent_post['post_title'], 0, 40, '...' ) );
							$recent_post_category = get_the_category( $recent_post['ID'] );
							if ( ! empty( $recent_post_category ) ) { // Showing only first category
								$recent_post_category = astareh_get_terms_html( $recent_post_category )['term_names'];
							}
							$time_stamp = strtotime( $recent_post['post_date'] );
							$recent_post_date = date( 'Y/m/d', $time_stamp );

							if ( is_rtl() && function_exists( 'jdate' ) ) {
								$recent_post_date = jdate( $recent_post_date )->format( 'd F Y' );
							}

							$recent_post_likes = MetaBoxController::getMetaValue( 'post-likes', true, 0, $recent_post['ID'] );
							$recent_post_permalink = esc_html( get_permalink( $recent_post['ID'] ) );
							$post_has_likes = true; // TODO : COMPLETE THE HAS LIKE FEATURE
							?>

							<div class="col-lg-3 col-md-6 col-12">
								<div class="post-item d-flex flex-column p-3 rounded-4">
									<div class="post-img d-flex rounded-4 overflow-hidden position-relative">
										<div class="filter position-absolute w-100 h-100 z-1"></div>
										<img class="w-100" src="<?php echo esc_url( $recent_post_thumbnail ) ?>" alt="">
									</div>
									<div class="post-title mt-3">
										<a href="<?php echo esc_url( $recent_post_permalink ); ?>" class="color-secondary-600">
											<?php echo esc_html( $recent_post_title ) ?>
										</a>
									</div>
									<div class="post-category mt-2">
										<p>
											<?php echo $recent_post_category; ?>
										</p>
									</div>
									<div class="spacer my-3"></div>
									<div class="post-date-read-more d-flex px-2 overflow-hidden">
										<div class="post-date d-flex align-items-center">
											<div class="date-icon d-flex me-2">
												<img class="w-100" src="<?php echo esc_url( $calendar_icon ) ?>" alt="">
											</div>
											<a class="d-flex d-xl-flex text-white">
												<?php echo esc_html( $recent_post_date ) ?>
											</a>
										</div>
										<div class="post-likes-read-more-cnt ms-auto position-relative w-fit">
											<div class="post-likes-read-more position-absolute d-flex flex-column w-fit has-like">
												<!--TODO : INCLUDE LIKES-->
												<div class="post-likes d-flex ms-auto">
												</div>

												<!--<div class="post-likes d-flex ms-auto">
													<div class="post-likes-icon d-flex me-2">
														<img class="w-100" src="<?php /*echo esc_url($like_icon) */ ?>"
															 alt="">
													</div>
													<a>
														<?php
                                                    /*printf(
                                                        __("%1s Likes", _get_theme_constant('THEME_TEXTDOMAIN')),
                                                        $recent_post_likes
                                                    );
                                                    */ ?>
													</a>
												</div>-->
												<div
													class="post-read-more d-flex flex-column justify-content-center align-items-center bg-secondary-600 rounded-3 px-2 py-2 w-fit mt-5">
													<a class="color-primary-500"
														href="<?php echo esc_url( $recent_post_permalink ); ?>">
														<?php echo esc_html__( 'View Details', _get_theme_constant( 'THEME_TEXTDOMAIN' ) ) ?>
													</a>
												</div>
											</div>
										</div>
									</div>

								</div>
							</div>
						<?php endforeach; ?>

					</div>
				</div>
			</div>
		</section>
		<?php
	endif;
	?>


	<?php
	/* User Comments */
	if ( $enable_comments ) {
		comments_template( '/custom-comments.php' );
	}
	?>


	<?php
endwhile;