<?php

/**
 * The template for displaying singular post-types: posts, pages and user-defined custom post types.
 *
 * @package ResumeChi
 */

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}



use RTLPlugins\AstarehCore\Controllers\MetaboxController;
use RTLPlugins\AstarehCore\Controllers\OptionController;
use RTLPlugins\AstarehCore\Helper as CoreHelper;

// Enqueue assets
wp_enqueue_style(__THEME_PREFIX . 'swiper-bundle');
wp_enqueue_script(__THEME_PREFIX . 'swiper-bundle');
wp_enqueue_script(__THEME_PREFIX . 'single-portfolio');

while (have_posts()) :
	the_post();

	if (function_exists('astareh_breadcrumb')) {
		astareh_breadcrumb();
	}


	$play_icon_url = get_template_directory_uri() . '/assets/images/play-icon.svg';
	/**
	 * Prepare gallery src url array
	 * We should return an array which holds the type, image hq size and image thumbnail
	 * [
	 *     [
	 *       'type' => 'mimetype',
	 *       'thumbnail' => 'https://...../',
	 *       'high_quality' => 'https://...../',
	 *     ]
	 * ]
	 */
	// ONLY IMAGE EXISTS IN GALLERY ATTACHMENTS
	$post_image_gallery = [];
	$post_gallery_attachments = MetaboxController::getMetaValue('portfolio-gallery');
	if (! empty($post_gallery_attachments)) {
		$post_gallery_attachment_ids = explode(',', $post_gallery_attachments);
		foreach ($post_gallery_attachment_ids as $post_gallery_attachment_id) {
			$thumbnail = wp_get_attachment_image_src($post_gallery_attachment_id, 'thumbnail');
			$high_quality = wp_get_attachment_image_src($post_gallery_attachment_id, 'full');
			if (! isset($thumbnail[0]) || ! isset($high_quality[0])) {
				continue;
			}
			$post_image_gallery[] = [
				'id' => $post_gallery_attachment_id,
				'type' => get_post_mime_type($post_gallery_attachment_id),
				'thumbnail' => $thumbnail[0],
				'high_quality' => $high_quality[0]
			];
		}
	}


	/**
	 * Videos are added as a repeater which presents the video itself and the poster thumbnail
	 * */
	$post_video_gallery = [];
	$post_video_attachments = MetaboxController::getMetaValue('portfolio-videos');
	if (
		! empty($post_video_attachments) &&
		(
			! empty($post_video_attachments['portfolio-video'][0]['url'])
			&& ! empty($post_video_attachments['portfolio-video-poster'][0]['url'])
		)
	) {
		foreach ($post_video_attachments['portfolio-video'] as $index => $post_video_attachment) {
			$post_video_gallery[] = [
				'id' => $post_video_attachment['id'],
				'type' => get_post_mime_type($post_video_attachment['id']),
				'thumbnail' => $post_video_attachments['portfolio-video-poster'][$index]['url'],
				'high_quality' => $post_video_attachment['url']
			];
		}
	}


	/*Employer*/
	$employer = MetaboxController::getMetaValue('portfolio-employer');
	$employer_icon = MetaboxController::getMetaValue('portfolio-employer-icon');
	if (empty($employer_icon['url'])) {
		$date_icon = get_template_directory_uri() . '/assets/images/employer-icon.svg';
	} else {
		$date_icon = $employer_icon['url'];
	}
	/*DATE AND DURATION*/
	$start_date = astareh_portfolio_get_start_date(get_the_ID());
	$duration = MetaboxController::getMetaValue('portfolio-duration');
	$date_icon = MetaboxController::getMetaValue('portfolio-date-icon');
	if (empty($date_icon['url'])) {
		$date_icon = get_template_directory_uri() . '/assets/images/calendar-icon.svg';
	} else {
		$date_icon = $date_icon['url'];
	}

	/*LOCATION*/
	$location = MetaboxController::getMetaValue('portfolio-location');
	$location_icon = MetaboxController::getMetaValue('portfolio-location-icon');
	if (empty($date_icon['url'])) {
		$location_icon = get_template_directory_uri() . '/assets/images/location-icon.svg';
	} else {
		$location_icon = $date_icon['url'];
	}

?>

	<!--TODO : FIND A BETTER WAY ABOUT ENQUEUING STYLE OF EACH PAGE-->
	<!--Custom page font loading-->
	<style>
		<?php
		if (! empty(OptionController::getOptionValue('portfolio-single-font'))) :
			$page_font_string = implode(',', OptionController::getOptionValue('portfolio-single-font'));
		?>.rc-single-portfolio {
			font-family:
				<?php echo esc_html($page_font_string); ?>;
		}

		<?php
		endif;
		?>
	</style>

	<section class="rc-sec-single-portfolio">
		<div class="container">
			<div class="rc-single-portfolio">
				<!--SLIDER-->
				<div class="rc-title-single-portfolio-cnt p-3 rounded-3 bg-primary-600 d-flex align-items-center my-5">
					<div class="rc-title-single-portfolio">
						<h1 class="color-secondary-600 text-xx1 entry-title">
							<?php echo esc_html__(the_title('', '', false), _get_theme_constant('THEME_TEXTDOMAIN')); ?>
						</h1>
					</div>
					<?php get_template_part('template-parts/share-box'); ?>
				</div>
				<div class="rc-cm-slider-1 position-relative">
					<div class="rc-slider-cnt ps-1 pt-1 pe-1  ps-md-5 pt-md-5 pe-md-5 bg-primary-600 rounded-4">
						<div class="rc-cm-slider-1-slider-top">
							<div class="swiper rcSinglePortfolio">
								<div class="swiper-wrapper align-items-center d-flex">

									<!--VIDEO-->
									<?php if (! empty($post_video_gallery)) : ?>
										<?php foreach ($post_video_gallery as $post_video) : ?>
											<div class="swiper-slide justify-content-center">
												<div class="rc-cm-video-player d-flex flex-column-reverse">
													<video tabindex="0" preload="metadata"
														class="rc-cm-video-player-video rounded-5 w-100"
														poster="<?php echo esc_url($post_video['thumbnail']); ?>">
														<source src="<?php echo esc_url($post_video['high_quality']); ?>"
															type="video/mp4">
													</video>
													<div class="rc-cm-video-player-button">
														<img src="<?php echo esc_url($play_icon_url) ?>"
															alt="<?php echo __('Play', _get_theme_constant('THEME_TEXTDOMAIN')) ?>">
													</div>
												</div>
											</div>
										<?php endforeach; ?>
									<?php endif; ?>

									<!--IMAGE-->
									<?php if (! empty($post_image_gallery)) : ?>
										<?php foreach ($post_image_gallery as $post_image) : ?>
											<div class="swiper-slide">
												<div class="swiper-zoom-container">
													<img class="rc-cm-slider-one-slider-top-img"
														src="<?php echo esc_url($post_image['high_quality']); ?>" alt="" />
												</div>
											</div>
										<?php endforeach; ?>
									<?php endif; ?>

								</div>
								<div class="swiper-rtl rc-swiper-portfolio-btn-one position-absolute w-100 h-100 top-0">
									<div class="rc-btn-slider-control-cnt">
										<div class="swiper-button-next"></div>
										<div class="swiper-button-prev"></div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="rc-cm-slider-1-slider-dw position-relative mt-4">
						<div class="swiper rcSinglePortfolioDw position-relative">
							<div class="swiper-wrapper d-flex align-items-center">

								<!--VIDEO POSTER-->
								<?php if (! empty($post_video_gallery)) : ?>
									<?php foreach ($post_video_gallery as $post_video) : ?>
										<div class="swiper-slide">
											<img src="<?php echo esc_url($post_video['thumbnail']) ?>" alt="" />
										</div>
									<?php endforeach; ?>
								<?php endif; ?>

								<!--IMAGE THUMBNAIL-->
								<?php if (! empty($post_image_gallery)) : ?>
									<?php foreach ($post_image_gallery as $post_image) : ?>
										<div class="swiper-slide">
											<img src="<?php echo esc_url($post_image['thumbnail']); ?>" alt="" />
										</div>
									<?php endforeach; ?>
								<?php endif; ?>
							</div>
						</div>

					</div>
					<!--<div class="rc-cm-slider-1-bg position-absolute w-100 bg-primary-600 top-0 rounded-4"></div>-->
				</div>


				<div class="rc-cm-project-information w-100 d-flex flex-column flex-md-row">
					<!--METAS-->
					<div class="w-md-35 w-100 d-flex flex-column">

						<!--EMPLOYER-->
						<?php if (! empty($employer)) : ?>
							<div class="rc-item-information d-flex p-3 mb-3 rounded-3 align-items-center">
								<div class="rc-item-information-img-item p-3 bg-primary-600 rounded-3">
									<img class="w-100" src="<?php echo esc_url($employer_icon['url']) ?>"
										alt="<?php echo esc_html__('Employer', _get_theme_constant('THEME_TEXTDOMAIN')) ?>">
								</div>
								<div class="rc-item-information-titles d-flex flex-column">
									<div class="rc-item-information-title-top mb-2">
										<p>
											<?php

											$post_id = get_the_ID();

											$meta = get_post_meta($post_id, 'opt-textopt-text-field-first', true);


											echo esc_html__($meta, _get_theme_constant('THEME_TEXTDOMAIN')) ?>
										</p>
									</div>
									<div class="rc-item-information-title-dw">
										<p class="color-secondary-600">
											<?php echo esc_html__($employer, _get_theme_constant('THEME_TEXTDOMAIN')) ?>
										</p>
									</div>
								</div>
							</div>
						<?php endif; ?>

						<!--DATE AND DURATION-->
						<?php if (! empty($start_date)) : ?>
							<div class="rc-item-information d-flex p-3 mb-3 rounded-3 align-items-center">
								<div class="rc-item-information-img-item p-3 bg-primary-600 rounded-3">
									<img class="w-100" src="<?php echo esc_url($date_icon) ?>"
										alt="<?php esc_html_e('Date') ?>">
								</div>
								<div class="rc-item-information-titles d-flex flex-column">
									<div class="rc-item-information-title-top mb-2">
										<p>

											<?php


											$meta_2 = get_post_meta($post_id, 'opt-textopt-text-field-second', true);


											echo esc_html__($meta_2, _get_theme_constant('THEME_TEXTDOMAIN')) ?>

										</p>
									</div>
									<div class="rc-item-information-title-dw">
										<p class="color-secondary-600">
											<?php
											echo esc_html($start_date);
											?>
											<?php if (! empty($duration)) : ?>
												&nbsp;|&nbsp;
												<?php esc_html_e($duration, _get_theme_constant('THEME_TEXTDOMAIN')) ?>
											<?php endif; ?>
										</p>
									</div>
								</div>
							</div>
						<?php endif; ?>

						<!--LOCATION-->
						<?php if (! empty($location)) : ?>
							<div class="rc-item-information d-flex p-3 rounded-3 align-items-center">
								<div class="rc-item-information-img-item p-3 bg-primary-600 rounded-3">
									<img class="w-100" src="<?php echo esc_url($location_icon) ?>"
										alt="<?php esc_html_e('Location') ?>">
								</div>
								<div class="rc-item-information-titles d-flex flex-column">
									<div class="rc-item-information-title-top mb-2">
										<p>
											<?php //sc_html_e('Project Location', _get_theme_constant('THEME_TEXTDOMAIN'))

											$meta_3 = get_post_meta($post_id, 'opt-textopt-text-field-third', true);

											echo esc_html__($meta_3, _get_theme_constant('THEME_TEXTDOMAIN')) ?>
										</p>
									</div>
									<div class="rc-item-information-title-dw">
										<p class="color-secondary-600">
											<?php esc_html_e($location, _get_theme_constant('THEME_TEXTDOMAIN')) ?>
										</p>
									</div>
								</div>
							</div>
						<?php endif; ?>


					</div>

					<!--CONTENT-->
					<div class="w-md-65 w-100 d-flex p-4 bg-primary-450 rounded-3 ms-md-4 mt-4 mt-md-0">
						<div class="rc-cm-project-information-content d-flex flex-column">
							<div class="rc-cm-project-information-info-top">
								<?php the_content(); ?>
							</div>
						</div>
					</div>

				</div>
			</div>
		</div>
	</section>

<?php
endwhile;
