<?php
global $wp;
$current_page_url = add_query_arg( $wp->query_vars, home_url( $wp->request ) );

$share_icon_url = get_template_directory_uri() . '/assets/images/icon-share.svg';
$telegram_icon_url = get_template_directory_uri() . '/assets/images/telegram.svg';
$twitter_icon_url = get_template_directory_uri() . '/assets/images/twitter.svg';
$instagram_icon_url = get_template_directory_uri() . '/assets/images/insta.svg';
$linkedin_icon_url = get_template_directory_uri() . '/assets/images/linkedin.svg';
$facebook_icon_url = get_template_directory_uri() . '/assets/images/facebook.svg';
$copy_icon_url = get_template_directory_uri() . '/assets/images/copy.svg';
?>

<div class="rc-cm-title-box-one-share-cnt position-relative rounded-3 ms-auto">
	<div
		class="rc-cm-title-box-one-share d-flex flex-column justify-content-center align-items-center p-3 rounded-3 bg-primary-500 mt-lg-0 position-relative ms-auto ms-lg-0 w-fit">
		<img class="w-100" src="<?php echo esc_url( $share_icon_url ); ?>" alt="">
	</div>
	<div class="rc-share-link-page-cnt p-3 d-flex flex-column rounded-3 bg-primary-500 position-absolute">
		<div class="rc-share-link-page-socials d-flex justify-content-between">
			<input id="rc-link-this-page" type="text"
				   data-placeholder="<?php echo esc_url( $current_page_url ) ?>" hidden disabled>
			<a href="" id="rc-telegram-link-share" class="rc-share-link-page-social-item">
				<img class="w-100" src="<?php echo esc_url( $telegram_icon_url ); ?>" alt="">
			</a>
			<a href="" id="rc-twitter-link-share" class="rc-share-link-page-social-item">
				<img class="w-100" src="<?php echo esc_url( $twitter_icon_url ); ?>" alt="">
			</a>
			<a href="" id="rc-instagram-link-share" class="rc-share-link-page-social-item">
				<img class="w-100" src="<?php echo esc_url( $instagram_icon_url ); ?>" alt="">
			</a>
			<a href="" id="rc-linkedin-link-share" class="rc-share-link-page-social-item">
				<img class="w-100" src="<?php echo esc_url( $linkedin_icon_url ); ?>" alt="">
			</a>
			<a href="" id="rc-facebook-link-share" class="rc-share-link-page-social-item">
				<img class="w-100" src="<?php echo esc_url( $facebook_icon_url ); ?>" alt="">
			</a>
		</div>
		<div class="rc-share-link-page-link-page-now d-flex align-items-center bg-primary-600 rounded-3 p-2 mt-3">
			<div class="rc-share-link-page-link-page-now-link d-ltr d-flex align-items-center">
				<input type="text" disabled
					   placeholder="<?php echo esc_url( $current_page_url ) ?>"
					   data-placeholder="<?php echo esc_url( $current_page_url ) ?>">
			</div>
			<button class="rc-share-link-page-link-page-now-btn-copy bg-primary-500 rounded-3 ms-auto">
				<img class="w-100" src="<?php echo esc_url( $copy_icon_url ); ?>" alt="">
			</button>
		</div>
	</div>
</div>