<?php

/**
 *
 *
 * @package AstarehTheme
 */

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

use RTLPlugins\AstarehCore\Controllers\OptionController;
use RTLPlugins\AstarehCore\Helper as CoreHelper;

/*Enqueue needed assets*/

wp_enqueue_script(__THEME_PREFIX . 'mustache');
wp_enqueue_script(__THEME_PREFIX . 'isotope');
wp_enqueue_script(__THEME_PREFIX . 'archive-portfolio');
wp_enqueue_script(__THEME_PREFIX . 'iconsax');

// Create nonce for load more ajax
$load_more_nonce = wp_create_nonce("portfolio_archive_load_more_nonce");

// List of parent categories
$categories_orderby = OptionController::getOptionValue('portfolio-archive-category-orderby');
$categories_order = OptionController::getOptionValue('portfolio-archive-category-order');
$categories_hide_empty = (bool) OptionController::getOptionValue('portfolio-archive-category-hide-empty');

$categories = astareh_portfolio_get_parent_categories(
	$categories_orderby,
	$categories_order,
	$categories_hide_empty
);


$posts_orderby = OptionController::getOptionValue('portfolio-archive-post-orderby');
$posts_order = OptionController::getOptionValue('portfolio-archive-post-order');
$posts_per_page = OptionController::getOptionValue('portfolio-archive-post-first-index');
$portfolio_list = astareh_portfolio_get_all_items(
	[
		'orderby' => $posts_orderby,
		'order' => $posts_order,
		'posts_per_page' => $posts_per_page
	]
);

$calendar_icon_url = get_template_directory_uri() . '/assets/images/calendar-small-icon.svg';
$posts_read_more_text = OptionController::getOptionValue('portfolio-archive-post-read-more-text');

$posts_load_more_enable = OptionController::getOptionValue('portfolio-archive-load-more-enable');
$posts_load_more_text = OptionController::getOptionValue('portfolio-archive-load-more-text');


if (function_exists('astareh_breadcrumb')) {
	astareh_breadcrumb();
}

?>
<!--TODO : FIND A BETTER WAY ABOUT ENQUEUING STYLE OF EACH PAGE-->
<!--Custom page font loading-->
<style>
	<?php
	if (! empty(OptionController::getOptionValue('portfolio-archive-font'))) :
		$page_font_string = implode(',', OptionController::getOptionValue('portfolio-archive-font'));
	?>.rc-sec-work-samples {
		font-family:
			<?php echo esc_html($page_font_string); ?>;
	}

	<?php
	endif;
	?>
</style>

<section class="rc-sec-work-samples">
	<!--TODO : APPEND WIDGET AREA JUST LIKE IT-->
	<!--    <div class="widget-area">
		<?php /*if ( is_active_sidebar( 'page-sidebar' ) ) : */ ?>
			<?php /*dynamic_sidebar( 'page-sidebar' ); */ ?>
		<?php /*endif; */ ?>
	</div>-->

	<div class="container position-relative">
		<div class="title-section-start d-flex flex-md-row flex-column align-items-center mb-4">

			<?php
			/*Custom Post Type Archive Title*/
			if (
				OptionController::getOptionValue('portfolio-archive-title-theme-enable')
				&& ! OptionController::getOptionValue('portfolio-archive-title-enable')
			) :
			?>
				<div class="title-section-start-right mb-4 mb-md-0">
					<h1 class="color-secondary-600 text-center text-xx1">
						<?php

						echo __(
							post_type_archive_title('', false),
							_get_theme_constant('THEME_TEXTDOMAIN')
						);
						?>
					</h1>
				</div>

			<?php
			endif;
			?>


			<?php
			/*Custom User Title*/
			if (OptionController::getOptionValue('portfolio-archive-title-enable')) :
			?>
				<div class="title-section-start-right mb-4 mb-md-0">
					<h1 class="color-secondary-500 text-center entry-title text-lg">
						<?php
						echo __(
							OptionController::getOptionValue('portfolio-archive-title-text'),
							_get_theme_constant('THEME_TEXTDOMAIN')
						);
						?>
					</h1>
				</div>
			<?php
			endif;
			?>


			<?php if (OptionController::getOptionValue('portfolio-search-enable')) : ?>
				<!--SEARCH-->
				<div class="title-section-start-left ms-md-auto">

					<form role="search" method="get" class="rc-portfolio-search-form" action="<?php echo home_url('/'); ?>">

						<div class="search-box-side-cnt">
							<div class="title-section-search-box d-flex">
								<div class="title-section-input bg-primary-450 rounded-3 d-flex">
									<input name="post_type" type="hidden" value="portfolio" id="post_type" />
									<input name="s" value="<?php the_search_query(); ?>" type="text"
										class="w-100 bg-primary-450" placeholder="<?php echo __(
																						'Search',
																						_get_theme_constant('THEME_TEXTDOMAIN')
																					); ?>" />
								</div>
								<button type="submit"
									class="btn-search d-flex flex-column justify-content-center align-items-center bg-secondary-600 rounded-3 ms-2">
									<div class="icon-search">
										<div class="iconsax-outline-search-normal-1 text-white"></div>
									</div>
								</button>
							</div>
						</div>
					</form>
				</div>
			<?php endif;

			$random_string = CoreHelper::createRandomString();
			?>

		</div>
		<div class="rc-work-samples-container position-relative">
			<div class="rc-cm-post-type-filter-tab-btns d-flex flex-column">
				<div class="rc-cm-post-type-filter-tabs-cnt mt-4 rounded-3 py-2 bg-primary-600 overflow-x-auto">
					<ul class="rc-cm-post-type-filter-btn d-flex justify-content-md-center px-2">
						<button
							data-name="*"
							class="me-3 active px-3 py-2 rounded-3"
							data-widget-id="<?php echo esc_html($random_string) ?>">
							<a class="text-white text-nowrap">
								<?php echo esc_html__('All', _get_theme_constant('THEME_TEXTDOMAIN')); ?>
							</a>
						</button>
						<?php
						if (! empty($categories)) :
							foreach ($categories as $category) :
						?>
								<button
									data-name=".parent-term-<?php echo esc_attr($category->term_id) ?>"
									class="me-3 px-3 py-2 rounded-3"
									data-widget-id="<?php echo esc_html($random_string) ?>">
									<a class="text-white text-nowrap">
										<?php echo esc_html__($category->name, _get_theme_constant('THEME_TEXTDOMAIN')); ?>
									</a>
								</button>
						<?php
							endforeach;
						endif;
						?>
					</ul>
				</div>
			</div>
			<div class="rc-cm-post-type-filter-items mt-5 d-flex flex-column">
				<div class="row rc-cm-post-type-filter-grid" id="rc-cm-post-type-load-more-dynamic" data-widget-id="<?php echo esc_html($random_string) ?>">
					<?php
					foreach ($portfolio_list as $portfolio) :
					?>
						<div class="rc-cm-post-type-filter-grid-item col-xl-3 col-lg-4 col-12
						<?php echo esc_html($portfolio['term-classes']) ?>
						   ">
							<div class="rc-cm-post-type-filter-item mb-4 position-relative overflow-hidden rounded-4">
								<div class="rc-sec-work-samples-img-item position-relative rounded-4 overflow-hidden">
									<div class="rc-cm-post-type-filter-img-filter-1 w-100 h-100 position-absolute"></div>
									<div class="rc-cm-post-type-filter-img-filter-2 w-100 h-100 position-absolute"></div>
									<img class="w-100" src="<?php echo esc_url($portfolio['image']) ?>" alt="">
								</div>
								<div
									class="rc-cm-post-type-filter-titles-item position-absolute w-100 h-100 d-flex flex-column justify-content-end p-4">
									<div class="rc-cm-post-type-filter-titles-top">
										<h3>
											<a href="<?php echo esc_url($portfolio['link']); ?>" class="text-md text-white">
												<?php echo esc_html($portfolio['title']) ?>
											</a>
										</h3>
									</div>
									<div class="rc-cm-post-type-filter-title-center">
										<p class="color-secondary-600">
											<?php echo $portfolio['term-names'] ?>
										</p>
									</div>
									<div class="rc-cm-post-type-filter-title-bottom d-flex flex-column">
										<div class="rc-cm-post-type-filter-spacer mt-3 mb-3 bg-primary-300"></div>
										<div class="rc-cm-post-type-filter-date-read-more d-flex">
											<?php if (! empty($portfolio['date'])) : ?>
												<div class="rc-cm-post-type-filter-date d-flex align-items-center">
													<div class="rc-cm-post-type-filter-date-icon d-flex me-2">
														<img class="w-100" width="20px" height="20px"
															src="<?php echo esc_url($calendar_icon_url); ?>" alt="">
													</div>
													<a>
														<?php echo esc_html($portfolio['date']); ?>
													</a>
												</div>
											<?php endif; ?>
											<div
												class="rc-cm-post-type-filter-read-more d-flex flex-column justify-content-center align-items-center bg-secondary-600 px-3 py-2 rounded-3 ms-auto">
												<a class="color-primary-500"
													href="<?php echo esc_url($portfolio['link']) ?>">
													<?php
													echo __($posts_read_more_text, _get_theme_constant('THEME_TEXTDOMAIN'));
													?>
												</a>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php
					endforeach;

					?>


				</div>


				<?php if ($posts_load_more_enable && $posts_per_page > 0) : ?>
					<div class="more-work-samples position-sticky bottom  d-flex flex-column bg-secondary-500 rounded-3 align-items-center px-3 py-2 w-fit mx-auto mt-4"
						data-action="potfolio_archive_load_more" data-nonce="<?php echo esc_attr($load_more_nonce); ?>"
						data-offset="<?php echo esc_attr($posts_per_page) ?>"
						data-posts-per-page="<?php echo esc_attr($posts_per_page) ?>" data-page="2">
						<a class="color-primary-500" href="javascript:void(0);">
							<?php echo esc_html__(
								$posts_load_more_text,
								_get_theme_constant('THEME_TEXTDOMAIN')
							) ?>
						</a>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>

<!--Mustache html template of each item to generate-->
<script type="text/html" id="portfolio-template-js">
	<div class="rc-cm-post-type-filter-grid-item col-xl-3 col-lg-4 col-12 {{term-classes}} ">
		<div class="rc-cm-post-type-filter-item mb-4 position-relative overflow-hidden rounded-4">
			<div class="rc-sec-work-samples-img-item position-relative rounded-4 overflow-hidden">
				<div class="rc-cm-post-type-filter-img-filter-1 w-100 h-100 position-absolute"></div>
				<div class="rc-cm-post-type-filter-img-filter-2 w-100 h-100 position-absolute"></div>
				<img class="w-100"
					src="{{image}}"
					alt="">
			</div>
			<div
				class="rc-cm-post-type-filter-titles-item position-absolute w-100 h-100 d-flex flex-column justify-content-end p-4">
				<div class="rc-cm-post-type-filter-titles-top">
					<h3>
						<a href="{{link}}" class="text-md text-white">
							{{title}}
						</a>
					</h3>
				</div>
				<div class="rc-cm-post-type-filter-title-center">
					<p class="color-secondary-600">
						{{{term-names}}}
					</p>
				</div>
				<div class="rc-cm-post-type-filter-title-bottom d-flex flex-column">
					<div class="rc-cm-post-type-filter-spacer mt-3 mb-3 bg-primary-300"></div>
					<div class="rc-cm-post-type-filter-date-read-more d-flex">
						<div class="rc-cm-post-type-filter-date d-flex align-items-center">
							<div class="rc-cm-post-type-filter-date-icon d-flex me-2">
								<img class="w-100"
									width="20px"
									height="20px"
									src="<?php echo esc_url($calendar_icon_url); ?>"
									alt="">
							</div>
							<a>
								{{date}}
							</a>
						</div>
						<div
							class="rc-cm-post-type-filter-read-more d-flex flex-column justify-content-center align-items-center bg-secondary-600 px-3 py-2 rounded-3 ms-auto">
							<a class="color-primary-500"
								href="{{link}}">
								<?php
								echo __($posts_read_more_text, _get_theme_constant('THEME_TEXTDOMAIN'));
								?>
							</a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</script>