<?php // PHPCS:ignore

if (! class_exists('WC_Product')) {
	return;
}
/*
 * TODO: Woocommerce customization, would work without the core!
 */

/**
 * Return product discount
 * @param WC_Product $product
 *
 * @return string
 */
if (! function_exists('astareh_get_product_discount_percent')) {
	function astareh_get_product_discount_percent($product, $show_off_percent = true): string
	{

		$regular_price = (float) $product->get_regular_price();
		$sale_price = (float) $product->get_sale_price();
		$discount_percent = '';
		if ($regular_price > $sale_price && $regular_price > 0 && $sale_price > 0) {
			$discount_percent = round(($regular_price - $sale_price) / $regular_price * 100);
			$discount_percent .= '% ';
		}
		if (! empty($discount_percent) && $show_off_percent) {
			$discount_percent .= __(' Off', _get_theme_constant('THEME_TEXTDOMAIN'));
		}

		return $discount_percent;
	}
}

/**
 * Reorder woocommerce price
 * @return void
 */
if (! function_exists('astareh_woocommerce_template_single_price')) {

	function astareh_woocommerce_template_single_price(): void
	{
		remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
		add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 30);
	}
}
add_action('woocommerce_init', 'astareh_woocommerce_template_single_price');

/**
 * Reorder woocommerce rating
 */
if (! function_exists('astareh_woocommerce_template_single_rating')) {
	function astareh_woocommerce_template_single_rating(): void
	{
		remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
		add_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 28);
	}
}
add_action('woocommerce_init', 'astareh_woocommerce_template_single_rating');

/**
 * Reorder woocommerce single product meta
 * @return void
 */
if (! function_exists('astareh_woocommerce_template_single_meta')) {
	function astareh_woocommerce_template_single_meta(): void
	{
		remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
		add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 29);
	}
}
add_action('woocommerce_init', 'astareh_woocommerce_template_single_meta');

/**
 * Remove review tab from woocommerce single product
 * @param array $tabs
 * @return array
 */
if (! function_exists('astareh_woocommerce_remove_single_product_reviews_tab')) {
	function astareh_woocommerce_remove_single_product_reviews_tab($tabs): array
	{

		unset($tabs['reviews']);
		return $tabs;
	}
}
add_filter('woocommerce_product_tabs', 'astareh_woocommerce_remove_single_product_reviews_tab', 98);

/**
 * Reorder woocommerce archive order filter hook
 * @return void
 */
if (! function_exists('astareh_woocommerce_order_filter')) {
	function astareh_woocommerce_order_filter(): void
	{
		remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
		add_action('astareh/theme/woocommerce_show_order_filter', 'woocommerce_catalog_ordering', 30);
	}
}
add_action('woocommerce_init', 'astareh_woocommerce_order_filter');

/**
 * List all woocommerce popular categories by sell amount of product
 * @param int $category_count
 * @return array
 */
if (! function_exists('astareh_list_best_selling_woocommerce_categories')) {
	function astareh_list_best_selling_woocommerce_categories(int $category_count = 10): array
	{
		$args = [
			'post_type' => 'product',
			'posts_per_page' => -1,
			'meta_key' => 'total_sales', // Sort by total sales
			'orderby' => 'id',
		];

		$products = new WP_Query($args);
		$categories = [];
		while ($products->have_posts()) {
			$products->the_post();
			$product_cats = wp_get_post_terms(get_the_ID(), 'product_cat');
			// count index is the selling amount of products
			foreach ($product_cats as $cat) {
				if (isset($categories[$cat->term_id])) {
					$categories[$cat->term_id]['count']++;
				} else {
					$categories[$cat->term_id]['count'] = 1;
					$categories[$cat->term_id]['name'] = $cat->name;
					$categories[$cat->term_id]['link'] = get_term_link($cat);
				}
			}
		}

		uasort($categories, function ($a, $b) {
			return $b['count'] - $a['count'];
		});
		return array_slice($categories, 0, $category_count, true);
	}
}


/**
 * Enable woocommerce registration in the separate page
 * The site.test/my-account?action=register will be the registration page
 * @return string
 */
if (! function_exists('astareh_wc_get_template')) {
	function astareh_wc_get_template($template, $template_name, $args, $template_path, $default_path): string
	{
		if (($template_name == 'myaccount/form-login.php')
			&& array_key_exists('action', $_GET)
			&& ($_GET['action'] == 'register')
		) {
			// The register form is placed in the theme/woocommerce/myaccount/form-register.php
			$template = get_template_directory() . '/woocommerce/myaccount/form-register.php';
		}
		return $template;
	}
}
add_filter('wc_get_template', 'astareh_wc_get_template', 10, 5);

/**
 * Return the register page form url
 * @return string
 */
if (! function_exists('astareh_wc_get_register_url')) {
	function astareh_wc_get_register_url(): string
	{
		$my_account_page_url = get_permalink(get_option('woocommerce_myaccount_page_id'));
		return add_query_arg('action', 'register', $my_account_page_url);
	}
}

/**
 * Validate privacy policy checkbox of woocommerce registration form
 * @return void
 */
if (! function_exists('astareh_woocommerce_register_form_validate_privacy_policy_checkbox')) {
	function astareh_woocommerce_register_form_validate_privacy_policy_checkbox($username, $email, $validation_errors): void
	{
		if (! isset($_POST['privacy_policy'])) {
			$validation_errors->add(
				'privacy_policy_error',
				__('Privacy policy agreement is required!', _get_theme_constant('THEME_TEXTDOMAIN'))
			);
		}
	}
}
add_action('woocommerce_register_post', 'astareh_woocommerce_register_form_validate_privacy_policy_checkbox', 10, 3);


/**
 * Disable the demo store and run it after the bread crumb
 * This method is integrated with astareh_bread_crumb actions.
 * @return void
 */

if (! function_exists('astareh_woocommerce_reorder_demo_store')) {
	function astareh_woocommerce_reorder_demo_store()
	{
		remove_action('wp_footer', 'woocommerce_demo_store');
		add_action('astareh/theme/after/breadcrumb', 'woocommerce_demo_store');
	}
}
add_action('woocommerce_init', 'astareh_woocommerce_reorder_demo_store');

/**
 * Redirect the user to the shopping cart after new add to cart
 * @return string
 */
if (! function_exists('astareh_woocommerce_add_to_cart_redirect')) {
	function astareh_woocommerce_add_to_cart_redirect($url, $adding_to_cart): string
	{
		return wc_get_cart_url();
	}
}
add_filter('woocommerce_add_to_cart_redirect', 'astareh_woocommerce_add_to_cart_redirect', 10, 2);

/**
 * Append cols to the product categories if enabled in shop page
 * @retunr array
 */
if (! function_exists('astareh_woocommerce_shop_product_category_classes')) {
	function astareh_woocommerce_shop_product_category_classes($classes): array
	{
		$classes[] = 'col-lg-6 col-md-12 col-12';
		return $classes;
	}
}
add_filter('product_cat_class', 'astareh_woocommerce_shop_product_category_classes');

/**
 * Disable some customizer options in woocommerce
 * @return void
 */
if (! function_exists('astareh_woocommerce_disable_customizer_controls')) {
	function astareh_woocommerce_disable_customizer_controls($wp_customize): void
	{
		$wp_customize->remove_control('woocommerce_catalog_columns');
		$wp_customize->remove_control('woocommerce_catalog_rows');
		$wp_customize->remove_control('woocommerce_catalog_columns');
		$wp_customize->remove_control('woocommerce_default_catalog_orderby');
	}
}
add_action('customize_register', 'astareh_woocommerce_disable_customizer_controls', 20);

/**
 * Change woocommerce default breadcrumb
 * @return array
 */
if (! function_exists('astareh_woocommerce_change_breadcrumb_defaults')) {
	function astareh_woocommerce_change_breadcrumb_defaults($defaults): array
	{
		$defaults['wrap_before'] = '<div class="container"><nav class="woocommerce-breadcrumb" itemprop="breadcrumb">';
		$defaults['wrap_after'] = '</nav> </div>';
		return $defaults;
	}
}
add_filter('woocommerce_breadcrumb_defaults', 'astareh_woocommerce_change_breadcrumb_defaults');

/** My Function in theme  */

require_once 'my-func-theme.php';
