<?php

// Change this variable to the opt_name of YOUR project.
$opt_name = '__resumechi_options';

// Check if the Redux_Metaboxes class exists before using it
if (class_exists('Redux_Metaboxes')) {
    Redux_Metaboxes::set_box(
        $opt_name,
        array(
            'id'         => 'opt-metaboxes',
            'title'      => esc_html__('گزینه های نمونه کار',  _get_theme_constant('THEME_TEXTDOMAIN')),
            'post_types' => array('portfolio'),
            'position'   => 'normal', // normal, advanced, side.
            'priority'   => 'high',   // high, core, default, low.
            'sections'   => array(
                array(
                    'title'      => esc_html__('اطلاعات نمونه کار',  _get_theme_constant('THEME_TEXTDOMAIN')),
                    'icon'       => 'el-icon-cog',
                    'id'         => 'opt-textopt-section',
                    'subsection' => true,
                    'fields'     => array(
                        array(
                            'title'   => esc_html__('متن کارفرمای پروژه',  _get_theme_constant('THEME_TEXTDOMAIN')),
                            'id'      => 'opt-textopt-text-field-first',
                            'type'    => 'text',
                            'default' => 'کارفرمای پروژه',
                        ),
                        array(
                            'title'   => esc_html__('متن تاریخ و مدت',  _get_theme_constant('THEME_TEXTDOMAIN')),
                            'id'      => 'opt-textopt-text-field-second',
                            'type'    => 'text',
                            'default' => 'تاریخ و مدت',
                        ),
                        array(
                            'title'   => esc_html__('متن محل پروژه', _get_theme_constant('THEME_TEXTDOMAIN')),
                            'id'      => 'opt-textopt-text-field-third',
                            'type'    => 'text',
                            'default' => 'محل پروژه',
                        ),
                    ),
                ),
            ),
        )
    );
} else {
    // Optional: Log an error or display a message if the class is not found
    error_log('Redux_Metaboxes class does not exist.');
}
