<?php
/**
 * Gallery Field.
 *
 * @package     ReduxFramework/Fields
 * @author      Dovy Paukstys & Kevin Provance (kprovance)
 * @version     4.0.0
 */

defined('ABSPATH') || exit;

// Don't duplicate me!
if (!class_exists('Redux_Gallery', false)) {

    /**
     * Main Redux_gallery class
     *
     * @since       3.0.0
     */
    class Redux_Gallery extends Redux_Field
    {

        /**
         * Field Render Function.
         * Takes the vars and outputs the HTML for the field in the settings
         *
         * @return      void
         * @since       1.0.0
         * @access      public
         */
        public function render()
        {
            echo '<div class="screenshot">';

            if (!empty($this->value)) {
                $ids = explode(',', $this->value);

                foreach ($ids as $attachment_id) {
                    ///  RTL : COMPATIBLE WITH VIDEO
                    /// NOT COMPATIBLE WITH MEDIA PREVIEW IN LIBRARY!
                    /*CHECK IF VIDEO */
                    $mime_type = get_post_mime_type($attachment_id);
                    if (preg_match('/video/', $mime_type)) {
                        $video_url = wp_get_attachment_url($attachment_id);
                        echo '<a target="_blank" class="of-uploaded-image" href="' . esc_url($video_url) . '">';
                        echo '<video class="redux-option-image" id="image_' . esc_attr($this->field['id']) . '_' . esc_attr($attachment_id) . '" src="' . esc_url($video_url) . '"></video>';
                        echo '</a>';
                    } else {
                        $img = wp_get_attachment_image_src($attachment_id);
                        /*Check if image existence*/
                        if (!empty($img)) {
                            $alt = wp_prepare_attachment_for_js($attachment_id);
                            $alt = $alt['alt'] ?? '';

                            echo '<a target="_blank" class="of-uploaded-image" href="' . esc_url($img[0]) . '">';
                            echo '<img class="redux-option-image" id="image_' . esc_attr($this->field['id']) . '_' . esc_attr($attachment_id) . '" src="' . esc_url($img[0]) . '" alt="' . esc_attr($alt) . '" target="_blank" rel="external" />';
                            echo '</a>';
                        }
                    }


                }

            }

            echo '</div>';
            echo '<a href="#" onclick="return false;" id="edit-gallery" class="gallery-attachments button button-primary">' . esc_html__('Add/Edit Gallery', 'redux-framework') . '</a> ';
            echo '<a href="#" onclick="return false;" id="clear-gallery" class="gallery-attachments button">' . esc_html__('Clear Gallery', 'redux-framework') . '</a>';
            echo '<input type="hidden" class="gallery_values ' . esc_attr($this->field['class']) . '" value="' . esc_attr($this->value) . '" name="' . esc_attr($this->field['name'] . $this->field['name_suffix']) . '" />';
        }

        /**
         * Enqueue Function.
         * If this field requires any scripts, or css define this function and register/enqueue the scripts/css
         *
         * @return      void
         * @since       1.0.0
         * @access      public
         */
        public function enqueue()
        {

            if (function_exists('wp_enqueue_media')) {
                wp_enqueue_media();
            } else {
                wp_enqueue_script('media-upload');
                wp_enqueue_script('thickbox');
                wp_enqueue_style('thickbox');
            }

            wp_enqueue_script(
                'redux-field-gallery-js',
                Redux_Core::$url . 'inc/fields/gallery/redux-gallery' . Redux_Functions::is_min() . '.js',
                ['jquery', 'redux-js'],
                $this->timestamp,
                true
            );
        }
    }
}

class_alias('Redux_Gallery', 'ReduxFramework_Gallery');
