/*global jQuery, redux*/

(function( $ ) {
	'use strict';

	redux.field_objects      = redux.field_objects || {};
	redux.field_objects.date = redux.field_objects.date || {};

	redux.field_objects.date.init = function( selector ) {
		selector = $.redux.getSelector( selector, 'date' );

		$( selector ).each(
			function() {
				var el     = $( this );
				var parent = el;

				if ( ! el.hasClass( 'redux-field-container' ) ) {
					parent = el.parents( '.redux-field-container:first' );
				}

				if ( parent.is( ':hidden' ) ) {
					return;
				}

				if ( parent.hasClass( 'redux-field-init' ) ) {
					parent.removeClass( 'redux-field-init' );
				} else {
					return;
				}

				el.find( '.redux-datepicker' ).each(
					function() {
						$( this ).persianDatepicker({
							formatDate: astareh_params.jalali_date_format,
							isRTL:!0  //  isRTL:!0 => because of persian words direction
						});
					}
				);
			}
		);
	};
})( jQuery );
