<?php
//version : major.minor.revision
define( 'ASTAREH_CORE_VERSION', '1.0.1' );
//demo slug
define( 'ASTAREH_CORE_DEMO_SLUG', 'resumechi' );
//demo name
define( 'ASTAREH_CORE_DEMO_NAME', 'ResumeChi' );
//prefix for anything for specific demo name
define( 'ASTAREH_CORE_PREFIX', 'resumechi_' );
//text-domain
define( 'ASTAREH_CORE_TEXTDOMAIN', 'astareh-core' );
//core plugin name
define( 'ASTAREH_CORE_PLUGIN_NAME', ASTAREH_CORE_DEMO_NAME . ' Core' );

//absolute path of this file
define( 'ASTAREH_CORE__FILE__', __FILE__ );
//base path of plugin in wp-content: prefix-core/prefix-core.php
define( 'ASTAREH_CORE_PLUGIN_BASE', plugin_basename( ASTAREH_CORE__FILE__ ) );
//absolute path to the plugin directory: path/to/prefix-core/
define( 'ASTAREH_CORE_PATH', plugin_dir_path( ASTAREH_CORE__FILE__ ) );
//absolute path to the plugin assets
define( 'ASTAREH_CORE_ASSETS_PATH', ASTAREH_CORE_PATH . 'assets/' );
//absolute path to the composer vendor library
define( 'ASTAREH_CORE_LIBRARY_PATH', ASTAREH_CORE_PATH . 'vendor/' );
//absolute path to the source directory of core
define( 'ASTAREH_CORE_SOURCE_PATH', ASTAREH_CORE_PATH . 'src/' );
//absolute path to the redux framework
define( 'ASTAREH_CORE_REDUX_PATH', ASTAREH_CORE_LIBRARY_PATH . 'wpackagist-plugin/redux-framework/' );
//set icon for settings
define( 'ASTAREH_ADMIN_ICON', 'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjIzcHgiIGhlaWdodD0iMTdweCIgc3R5bGU9InNoYXBlLXJlbmRlcmluZzpnZW9tZXRyaWNQcmVjaXNpb247IHRleHQtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgaW1hZ2UtcmVuZGVyaW5nOm9wdGltaXplUXVhbGl0eTsgZmlsbC1ydWxlOmV2ZW5vZGQ7IGNsaXAtcnVsZTpldmVub2RkIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CjxnPjxwYXRoIHN0eWxlPSJvcGFjaXR5OjAuODE1IiBmaWxsPSIjZjBmNmZjOTkiIGQ9Ik0gLTAuNSwtMC41IEMgNi41LC0wLjUgMTMuNSwtMC41IDIwLjUsLTAuNUMgMjAuODMzMywwLjUgMjEuNSwxLjE2NjY3IDIyLjUsMS41QyAyMi41LDMuMTY2NjcgMjIuNSw0LjgzMzMzIDIyLjUsNi41QyAxNi45NjUzLDkuMDYyOSAxNi4yOTg2LDEyLjM5NjIgMjAuNSwxNi41QyAxNy41LDE2LjUgMTQuNSwxNi41IDExLjUsMTYuNUMgMTAuMjg3LDEzLjc3NDYgOC40NTM2MiwxMS40NDEyIDYsOS41QyA0Ljk4MDUyLDEwLjY4NzIgMy44MTM4NiwxMS42ODcyIDIuNSwxMi41QyAxLjcxMjM3LDExLjIyOTkgMC43MTIzNzEsMTAuMjI5OSAtMC41LDkuNUMgLTAuNSw4LjUgLTAuNSw3LjUgLTAuNSw2LjVDIDIuMTY2NjcsNC44MzMzMyAyLjE2NjY3LDMuMTY2NjcgLTAuNSwxLjVDIC0wLjUsMC44MzMzMzMgLTAuNSwwLjE2NjY2NyAtMC41LC0wLjUgWiBNIDkuNSw0LjUgQyAxNS43ODM5LDQuMTI3MjkgMTYuMTE3Miw1LjEyNzI5IDEwLjUsNy41QyA5LjUsNy4zMzMzMyA4LjUsNy4xNjY2NyA3LjUsN0MgOC4zODA1Myw2LjI5MTcgOS4wNDcyLDUuNDU4MzcgOS41LDQuNSBaIi8+PC9nPgo8L3N2Zz4K' ); // phpcs:ignore Generic.Files.LineLength
//plugin url
define( 'ASTAREH_CORE_URL', plugins_url( '/', ASTAREH_CORE__FILE__ ) );
//plugin source url
define( 'ASTAREH_CORE_SOURCE_URL', ASTAREH_CORE_URL . 'src/' );
//assets url
define( 'ASTAREH_CORE_ASSETS_URL', ASTAREH_CORE_URL . 'assets/' );
//development mode, it'll define development style of redux and assets,
define( 'ASTAREH_CORE_DEV_MODE', false );


//native fonts which will be used in theme
define( 'ASTAREH_CORE_FONTS', [ 
	'anjoman' => 'Anjoman',
	'iranyekan' => 'IranYekan',
] );


//required plugins by the core : this is the tgmpa content requirement
define( 'ASTAREH_CORE_REQUIRED_PLUGINS', [ 
	[ 
		'name' => __( ASTAREH_CORE_DEMO_NAME . ' Widgets', ASTAREH_CORE_TEXTDOMAIN ),
		'slug' => ASTAREH_CORE_DEMO_SLUG . '-widgets',
		'source' => 'https://p.ucweb.site/resumechi/resumechi-widgets.zip',
		'required' => true,
	],
	[ 
		'name' => __( "Elementor", ASTAREH_CORE_TEXTDOMAIN ),
		'slug' => 'elementor',
		'required' => true
	],
	[ 
		'name' => __( "WooCommerce", ASTAREH_CORE_TEXTDOMAIN ),
		'slug' => 'woocommerce',
		'required' => false
	],
	[ 
		'name' => __( "Contact Form 7", ASTAREH_CORE_TEXTDOMAIN ),
		'slug' => 'contact-form-7',
		'required' => false
	],

] );
