
(function( $ ) {
    'use strict';

    $.redux = $.redux || {};

    $.redux.expandOptions = function( parent ) {
        var trigger = parent.find( '.expand_options' );
        var width   = parent.find( '.redux-sidebar' ).width() - 1;
        var id      = $( '.redux-group-menu .active a' ).data( 'rel' ) + '_section_group';

        if ( trigger.hasClass( 'expanded' ) ) {
            trigger.removeClass( 'expanded' );
            parent.find( '.redux-main' ).removeClass( 'expand' );

            parent.find( '.redux-sidebar' ).stop().animate(
                { 'margin-right': '0px' },
                500
            );

            parent.find( '.redux-main' ).stop().animate(
                { 'margin-right': width },
                500,
                function() {
                    parent.find( '.redux-main' ).attr( 'style', '' );
                }
            );

            parent.find( '.redux-group-tab' ).each(
                function() {
                    if ( $( this ).attr( 'id' ) !== id ) {
                        $( this ).fadeOut( 'fast' );
                    }
                }
            );

            // Show the only active one.
        } else {
            trigger.addClass( 'expanded' );
            parent.find( '.redux-main' ).addClass( 'expand' );

            parent.find( '.redux-sidebar' ).stop().animate(
                { 'margin-right': - width - 113 },
                500
            );

            parent.find( '.redux-main' ).stop().animate(
                { 'margin-right': '-1px' },
                500
            );

            parent.find( '.redux-group-tab' ).fadeIn(
                'medium',
                function() {
                    $.redux.initFields();
                }
            );
        }

        return false;
    };
})( jQuery );


(function( $ ) {
    'use strict';

    $.redux = $.redux || {};

    $.redux.stickyInfo = function() {
        var stickyWidth = $( '.redux-main' ).innerWidth() - 20;
        var $width      = $( '#redux-sticky' ).offset().right;

        $( '.redux-save-warn' ).css( 'right', $width + 'px' );

        if ( ! $( '#info_bar' ).isOnScreen() && ! $( '#redux-footer-sticky' ).isOnScreen() ) {
            $( '#redux-footer' ).css(
                { position: 'fixed', bottom: '0', width: stickyWidth, left: 21 }
            );

            $( '#redux-footer' ).addClass( 'sticky-footer-fixed' );
            $( '#redux-sticky-padder' ).show();
        } else {
            $( '#redux-footer' ).css(
                { background: '#eee', position: 'inherit', bottom: 'inherit', width: 'inherit' }
            );

            $( '#redux-sticky-padder' ).hide();
            $( '#redux-footer' ).removeClass( 'sticky-footer-fixed' );
        }
        if ( ! $( '#info_bar' ).isOnScreen() ) {
            $( '#redux-sticky' ).addClass( 'sticky-save-warn' );
        } else {
            $( '#redux-sticky' ).removeClass( 'sticky-save-warn' );
        }
    };
})( jQuery );
